/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.screen.components;

import com.yanny.ytech.configuration.screen.components.IComponent;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

class LeftRightAnimationComponent
implements IComponent {
    protected final int x;
    protected final int y;
    protected final int uWidth;
    protected final int vHeight;
    protected final int uOffset;
    protected final int vOffset;
    protected final int uAnimationOffset;
    protected final int vAnimationOffset;
    protected int maxValue = 100;
    protected int value = 0;
    protected boolean renderAnimation = true;

    LeftRightAnimationComponent(int x, int y, int uWidth, int vHeight, int uOffset, int vOffset, int uAnimationOffset, int vAnimationOffset) {
        this.x = x;
        this.y = y;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uAnimationOffset = uAnimationOffset;
        this.vAnimationOffset = vAnimationOffset;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int left, int top) {
        int width = Math.min(Math.round((float)this.value / (float)this.maxValue * (float)this.uWidth), this.uWidth);
        int offset = Math.max(this.uWidth - width, 0);
        graphics.blit(GUI, left + this.x, top + this.y, this.uOffset, this.vOffset, this.uWidth, this.vHeight);
        if (this.renderAnimation) {
            graphics.blit(GUI, left + this.x, top + this.y, this.uAnimationOffset, this.vAnimationOffset, this.uWidth - offset, this.vHeight);
        }
    }

    public void set(int maxValue, int value) {
        this.maxValue = maxValue;
        this.value = value;
    }

    public void setRenderAnimation(boolean renderAnimation) {
        this.renderAnimation = renderAnimation;
    }
}

