/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AmphoraBlock;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block.AqueductFertilizerBlock;
import com.yanny.ytech.configuration.block.AqueductHydratorBlock;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block.BrickChimneyBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.PrimitiveAlloySmelterBlock;
import com.yanny.ytech.configuration.block.PrimitiveSmelterBlock;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block.StrainerBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.block.ToolRackBlock;
import com.yanny.ytech.configuration.block.TreeStumpBlock;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.EnumSet;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

class YTechBlockStateProvider
extends BlockStateProvider {
    public YTechBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ytech", exFileHelper);
    }

    protected void registerStatesAndModels() {
        AmphoraBlock.registerModel(this);
        AqueductFertilizerBlock.registerModel(this);
        AqueductHydratorBlock.registerModel(this);
        AqueductValveBlock.registerModel(this);
        BrickChimneyBlock.registerModel(this);
        BronzeAnvilBlock.registerModel(this);
        CraftingWorkspaceBlock.registerModel(this);
        FirePitBlock.registerModel(this);
        GrassBedBlock.registerModel(this);
        MillstoneBlock.registerModel(this);
        PottersWheelBlock.registerModel(this);
        PrimitiveAlloySmelterBlock.registerModel(this);
        PrimitiveSmelterBlock.registerModel(this);
        YTechBlockStateProvider.reinforcedBricksBlockState(this);
        ReinforcedBrickChimneyBlock.registerModel(this);
        StrainerBlock.registerModel(this);
        YTechBlockStateProvider.registerSimpleBlockState(this, YTechBlocks.TERRACOTTA_BRICKS);
        YTechBlockStateProvider.registerSlabBlockState(this, YTechBlocks.TERRACOTTA_BRICK_SLAB, Utils.getPath(YTechBlocks.TERRACOTTA_BRICKS));
        YTechBlockStateProvider.registerStairsBlockState(this, YTechBlocks.TERRACOTTA_BRICK_STAIRS, Utils.getPath(YTechBlocks.TERRACOTTA_BRICKS));
        YTechBlockStateProvider.registerSimpleBlockState(this, YTechBlocks.THATCH);
        YTechBlockStateProvider.registerSlabBlockState(this, YTechBlocks.THATCH_SLAB, Utils.getPath(YTechBlocks.THATCH));
        YTechBlockStateProvider.registerStairsBlockState(this, YTechBlocks.THATCH_STAIRS, Utils.getPath(YTechBlocks.THATCH));
        ToolRackBlock.registerModel(this);
        TreeStumpBlock.registerModel(this);
        WellPulleyBlock.registerModel(this);
        WoodenBoxBlock.registerModel(this);
        YTechBlocks.AQUEDUCTS.entries().forEach(entry -> AqueductBlock.registerModel(this, (DeferredBlock<Block>)((DeferredBlock)entry.getValue()), (MaterialType)entry.getKey()));
        YTechBlockStateProvider.registerMaterialBlockState(this, "deepslate_ore", YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS);
        YTechBlocks.DRYING_RACKS.entries().forEach(entry -> DryingRackBlock.registerModel(this, (DeferredBlock<Block>)((DeferredBlock)entry.getValue()), (MaterialType)entry.getKey()));
        YTechBlockStateProvider.registerMaterialBlockState(this, "gravel_deposit", YTechBlocks.GRAVEL_DEPOSITS);
        YTechBlockStateProvider.registerMaterialBlockState(this, "nether_ore", YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD));
        YTechBlockStateProvider.registerMaterialBlockState(this, "raw_storage", YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        YTechBlockStateProvider.registerMaterialBlockState(this, "sand_deposit", YTechBlocks.SAND_DEPOSITS);
        YTechBlockStateProvider.registerMaterialBlockState(this, "ore", YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS);
        YTechBlockStateProvider.registerMaterialBlockState(this, "storage", YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        YTechBlocks.TANNING_RACKS.entries().forEach(entry -> TanningRackBlock.registerModel(this, (DeferredBlock<Block>)((DeferredBlock)entry.getValue()), (MaterialType)entry.getKey()));
    }

    private static void reinforcedBricksBlockState(@NotNull BlockStateProvider provider) {
        String name = Utils.getPath(YTechBlocks.REINFORCED_BRICKS);
        BlockModelBuilder model = (BlockModelBuilder)provider.models().cubeBottomTop(name, Utils.modBlockLoc("reinforced_bricks"), Utils.blockLoc(Blocks.BRICKS), Utils.blockLoc(Blocks.BRICKS));
        provider.getVariantBuilder((Block)YTechBlocks.REINFORCED_BRICKS.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    private static void registerSimpleBlockState(@NotNull BlockStateProvider provider, DeferredBlock<Block> block) {
        String name = Utils.getPath(block);
        BlockModelBuilder model = (BlockModelBuilder)provider.models().cubeAll(name, Utils.modBlockLoc(name));
        provider.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    private static void registerSlabBlockState(BlockStateProvider provider, DeferredBlock<Block> block, String texture) {
        String name = Utils.getPath(block);
        ModelBuilder bottom = provider.models().slab(name, Utils.modBlockLoc(texture), Utils.modBlockLoc(texture), Utils.modBlockLoc(texture));
        ModelBuilder top = provider.models().slabTop(name + "_top", Utils.modBlockLoc(texture), Utils.modBlockLoc(texture), Utils.modBlockLoc(texture));
        ModelBuilder doubleSlab = provider.models().cubeAll(name + "_double", Utils.modBlockLoc(texture));
        provider.getVariantBuilder((Block)block.get()).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottom)}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)top)}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)bottom);
    }

    private static void registerStairsBlockState(BlockStateProvider provider, DeferredBlock<Block> block, String texture) {
        String name = Utils.getPath(block);
        ModelBuilder stairs = provider.models().stairs(name, Utils.modBlockLoc(texture), Utils.modBlockLoc(texture), Utils.modBlockLoc(texture));
        ModelBuilder stairsInner = provider.models().stairsInner(name + "_inner", Utils.modBlockLoc(texture), Utils.modBlockLoc(texture), Utils.modBlockLoc(texture));
        ModelBuilder stairsOuter = provider.models().stairsOuter(name + "_outer", Utils.modBlockLoc(texture), Utils.modBlockLoc(texture), Utils.modBlockLoc(texture));
        provider.stairsBlock((StairBlock)block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)stairs);
    }

    private static void registerMaterialBlockState(@NotNull BlockStateProvider provider, String group, YTechBlocks.MaterialBlock materialBlock) {
        materialBlock.entries().forEach(entry -> {
            DeferredBlock block = (DeferredBlock)entry.getValue();
            BlockModelBuilder model = (BlockModelBuilder)provider.models().cubeAll(Utils.getPath(block), Utils.modBlockLoc(group + "/" + ((MaterialType)entry.getKey()).key));
            model.element().allFaces((direction, faceBuilder) -> faceBuilder.texture("#all").cullface(direction).tintindex(0));
            provider.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
            ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(block))).parent((ModelFile)model);
        });
    }

    private static void registerMaterialBlockState(@NotNull BlockStateProvider provider, String group, YTechBlocks.MaterialBlock materialBlock, EnumSet<MaterialType> exclude) {
        materialBlock.entries().forEach(entry -> {
            if (!exclude.contains(entry.getKey())) {
                DeferredBlock block = (DeferredBlock)entry.getValue();
                BlockModelBuilder model = (BlockModelBuilder)provider.models().cubeAll(Utils.getPath(block), Utils.modBlockLoc(group + "/" + ((MaterialType)entry.getKey()).key));
                model.element().allFaces((direction, faceBuilder) -> faceBuilder.texture("#all").cullface(direction).tintindex(0));
                provider.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
                ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(block))).parent((ModelFile)model);
            }
        });
    }
}

