/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

class YTechBlockTagsProvider
extends BlockTagsProvider {
    public YTechBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "ytech", existingFileHelper);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.tag(YTechBlockTags.AMPHORAE).add((Object)((Block)YTechBlocks.AMPHORA.get()));
        this.tag(YTechBlockTags.AQUEDUCT_FERTILIZERS).add((Object)((Block)YTechBlocks.AQUEDUCT_FERTILIZER.get()));
        this.tag(YTechBlockTags.AQUEDUCT_HYDRATORS).add((Object)((Block)YTechBlocks.AQUEDUCT_HYDRATOR.get()));
        this.tag(YTechBlockTags.AQUEDUCT_VALVES).add((Object)((Block)YTechBlocks.AQUEDUCT_VALVE.get()));
        this.tag(YTechBlockTags.BRICK_CHIMNEYS).add((Object)((Block)YTechBlocks.BRICK_CHIMNEY.get()));
        this.tag(YTechBlockTags.BRONZE_ANVILS).add((Object)((Block)YTechBlocks.BRONZE_ANVIL.get()));
        this.tag(YTechBlockTags.CRAFTING_WORKSPACES).add((Object)((Block)YTechBlocks.CRAFTING_WORKSPACE.get()));
        this.tag(YTechBlockTags.FIRE_PITS).add((Object)((Block)YTechBlocks.FIRE_PIT.get()));
        this.tag(YTechBlockTags.GRASS_BEDS).add((Object)((Block)YTechBlocks.GRASS_BED.get()));
        this.tag(YTechBlockTags.MILLSTONES).add((Object)((Block)YTechBlocks.MILLSTONE.get()));
        this.tag(YTechBlockTags.POTTERS_WHEELS).add((Object)((Block)YTechBlocks.POTTERS_WHEEL.get()));
        this.tag(YTechBlockTags.PRIMITIVE_ALLOY_SMELTERS).add((Object)((Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get()));
        this.tag(YTechBlockTags.PRIMITIVE_SMELTERS).add((Object)((Block)YTechBlocks.PRIMITIVE_SMELTER.get()));
        this.tag(YTechBlockTags.REINFORCED_BRICKS).add((Object)((Block)YTechBlocks.REINFORCED_BRICKS.get()));
        this.tag(YTechBlockTags.REINFORCED_BRICK_CHIMNEYS).add((Object)((Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get()));
        this.tag(YTechBlockTags.STRAINERS).add((Object)((Block)YTechBlocks.STRAINER.get()));
        this.tag(YTechBlockTags.TERRACOTTA_BRICKS).add((Object)((Block)YTechBlocks.TERRACOTTA_BRICKS.get()));
        this.tag(YTechBlockTags.TERRACOTTA_BRICK_SLABS).add((Object)((Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get()));
        this.tag(YTechBlockTags.TERRACOTTA_BRICK_STAIRS).add((Object)((Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get()));
        this.tag(YTechBlockTags.THATCH).add((Object)((Block)YTechBlocks.THATCH.get()));
        this.tag(YTechBlockTags.THATCH_SLABS).add((Object)((Block)YTechBlocks.THATCH_SLAB.get()));
        this.tag(YTechBlockTags.THATCH_STAIRS).add((Object)((Block)YTechBlocks.THATCH_STAIRS.get()));
        this.tag(YTechBlockTags.TOOL_RACKS).add((Object)((Block)YTechBlocks.TOOL_RACK.get()));
        this.tag(YTechBlockTags.TREE_STUMPS).add((Object)((Block)YTechBlocks.TREE_STUMP.get()));
        this.tag(YTechBlockTags.WELL_PULLEYS).add((Object)((Block)YTechBlocks.WELL_PULLEY.get()));
        this.tag(YTechBlockTags.WOODEN_BOXES).add((Object)((Block)YTechBlocks.WOODEN_BOX.get()));
        this.tag(YTechBlockTags.AUROCHS_RAID_BLOCKS).add((Object)Blocks.WHEAT);
        this.tag(YTechBlockTags.DEER_RAID_BLOCKS).add((Object)Blocks.WHEAT);
        this.tag(YTechBlockTags.FOWL_RAID_BLOCKS).add((Object)Blocks.BEETROOTS);
        this.tag(YTechBlockTags.MOUFLON_RAID_BLOCKS).add((Object[])new Block[]{Blocks.WHEAT, Blocks.BEETROOTS, Blocks.PUMPKIN_STEM, Blocks.ATTACHED_PUMPKIN_STEM, Blocks.MELON_STEM, Blocks.ATTACHED_MELON_STEM});
        this.tag(YTechBlockTags.FIRE_SOURCE).add((Object[])new Block[]{Blocks.FIRE, Blocks.CAMPFIRE, Blocks.LANTERN, Blocks.TORCH, Blocks.WALL_TORCH, Blocks.FURNACE, Blocks.BLAST_FURNACE}).addTag(YTechBlockTags.FIRE_PITS).addTag(YTechBlockTags.PRIMITIVE_SMELTERS).addTag(YTechBlockTags.PRIMITIVE_ALLOY_SMELTERS);
        this.tag(YTechBlockTags.SOUL_FIRE_SOURCE).add((Object[])new Block[]{Blocks.SOUL_FIRE, Blocks.SOUL_CAMPFIRE, Blocks.SOUL_LANTERN, Blocks.SOUL_TORCH, Blocks.SOUL_WALL_TORCH});
        this.tag(YTechBlockTags.REQUIRE_VALID_TOOL).addTag(BlockTags.LOGS).addTag(BlockTags.DIRT);
        this.materialTag(YTechBlocks.AQUEDUCTS, YTechBlockTags.AQUEDUCTS);
        this.materialOreTag(YTechBlocks.DEEPSLATE_ORES, YTechBlockTags.DEEPSLATE_ORES, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.DRYING_RACKS, YTechBlockTags.DRYING_RACKS);
        this.materialTag(YTechBlocks.GRAVEL_DEPOSITS, YTechBlockTags.GRAVEL_DEPOSITS);
        this.materialOreTag(YTechBlocks.NETHER_ORES, YTechBlockTags.NETHER_ORES, EnumSet.of(MaterialType.GOLD));
        this.materialTag(YTechBlocks.RAW_STORAGE_BLOCKS, YTechBlockTags.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.SAND_DEPOSITS, YTechBlockTags.SAND_DEPOSITS);
        this.materialOreTag(YTechBlocks.STONE_ORES, YTechBlockTags.STONE_ORES, MaterialType.VANILLA_METALS);
        this.tieredMaterialTag(YTechBlocks.STORAGE_BLOCKS, YTechBlockTags.STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.TANNING_RACKS, YTechBlockTags.TANNING_RACKS);
        this.tag(BlockTags.ANVIL).add((Object)((Block)YTechBlocks.BRONZE_ANVIL.get()));
        this.tag(BlockTags.BEDS).add((Object)((Block)YTechBlocks.GRASS_BED.get()));
        this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS));
        this.tag(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD)));
        this.tag(Tags.Blocks.ORES_IN_GROUND_STONE).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS));
        this.tag(BlockTags.SLABS).add((Object[])new Block[]{(Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.THATCH_SLAB.get()});
        this.tag(BlockTags.STAIRS).add((Object[])new Block[]{(Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get(), (Block)YTechBlocks.THATCH_STAIRS.get()});
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)YTechBlocks.AMPHORA.get(), (Block)YTechBlocks.AQUEDUCT_FERTILIZER.get(), (Block)YTechBlocks.AQUEDUCT_HYDRATOR.get(), (Block)YTechBlocks.AQUEDUCT_VALVE.get(), (Block)YTechBlocks.BRICK_CHIMNEY.get(), (Block)YTechBlocks.BRONZE_ANVIL.get(), (Block)YTechBlocks.MILLSTONE.get(), (Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), (Block)YTechBlocks.PRIMITIVE_SMELTER.get(), (Block)YTechBlocks.REINFORCED_BRICKS.get(), (Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), (Block)YTechBlocks.TERRACOTTA_BRICKS.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get(), (Block)YTechBlocks.WELL_PULLEY.get()}).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.AQUEDUCTS, EnumSet.noneOf(MaterialType.class))).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS)).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD))).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS)).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS)).add((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS));
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.GRAVEL_DEPOSITS)).add((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.SAND_DEPOSITS));
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.DRYING_RACKS)).add((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.TANNING_RACKS)).add((Object)((Block)YTechBlocks.POTTERS_WHEEL.get())).add((Object)((Block)YTechBlocks.STRAINER.get())).add((Object)((Block)YTechBlocks.TOOL_RACK.get())).add((Object)((Block)YTechBlocks.TREE_STUMP.get())).add((Object)((Block)YTechBlocks.WOODEN_BOX.get()));
        this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object[])new Block[]{(Block)YTechBlocks.AQUEDUCT_FERTILIZER.get(), (Block)YTechBlocks.AQUEDUCT_HYDRATOR.get(), (Block)YTechBlocks.AQUEDUCT_VALVE.get(), (Block)YTechBlocks.BRICK_CHIMNEY.get(), (Block)YTechBlocks.BRONZE_ANVIL.get(), (Block)YTechBlocks.MILLSTONE.get(), (Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), (Block)YTechBlocks.PRIMITIVE_SMELTER.get(), (Block)YTechBlocks.REINFORCED_BRICKS.get(), (Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), (Block)YTechBlocks.TERRACOTTA_BRICKS.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get()});
    }

    private void materialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            this.tag(materialTag.of(material)).add((Object)((Block)materialItem.of(material).get()));
            this.tag(materialTag.tag).addTag(materialTag.of(material));
        });
    }

    private void materialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                this.tag(materialTag.of(material)).add((Object)((Block)materialItem.of(material).get()));
                this.tag(materialTag.tag).addTag(materialTag.of(material));
            }
        });
    }

    private void tieredMaterialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                this.tag(materialTag.of(material)).add((Object)((Block)materialItem.of(material).get()));
                this.tag(materialTag.tag).addTag(materialTag.of(material));
                this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)((Block)((DeferredBlock)entry.getValue()).get()));
            }
        });
    }

    private void materialOreTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                DeferredBlock<Block> block = materialItem.of(material);
                this.tag(materialTag.of(material)).add((Object)((Block)block.get()));
                this.tag(materialTag.tag).add((Object)((Block)block.get()));
                this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)((Block)((DeferredBlock)entry.getValue()).get()));
                switch (material) {
                    case IRON: {
                        this.tag(BlockTags.IRON_ORES).add((Object)((Block)block.get()));
                        break;
                    }
                    case COPPER: {
                        this.tag(BlockTags.COPPER_ORES).add((Object)((Block)block.get()));
                        break;
                    }
                    case GOLD: {
                        this.tag(BlockTags.GOLD_ORES).add((Object)((Block)block.get()));
                    }
                }
            }
        });
    }

    private static Block[] filteredMaterials(YTechBlocks.MaterialBlock block, EnumSet<MaterialType> exclude) {
        return (Block[])block.entries().stream().filter(entry -> !exclude.contains(entry.getKey())).sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).map(Map.Entry::getValue).map(DeferredHolder::get).toArray(Block[]::new);
    }

    private static Block[] sortedMaterials(YTechBlocks.MaterialBlock block) {
        return (Block[])block.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).map(Map.Entry::getValue).map(DeferredHolder::get).toArray(Block[]::new);
    }
}

