/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.PartType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block.AqueductFertilizerBlock;
import com.yanny.ytech.configuration.block.AqueductHydratorBlock;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block.BrickChimneyBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.PrimitiveAlloySmelterBlock;
import com.yanny.ytech.configuration.block.PrimitiveSmelterBlock;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.configuration.recipe.BlockHitRecipe;
import com.yanny.ytech.configuration.recipe.ChoppingRecipe;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.configuration.recipe.HammeringRecipe;
import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.configuration.recipe.PotteryRecipe;
import com.yanny.ytech.configuration.recipe.RemainingPartShapelessRecipe;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.configuration.recipe.RemainingShapelessRecipe;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.configuration.recipe.TanningRecipe;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

class YTechRecipeProvider
extends RecipeProvider {
    public YTechRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeConsumer) {
        this.mcSplitBySawRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_SLAB);
        this.mcSplitBySawRecipe(recipeConsumer, Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitBySawRecipe(recipeConsumer, Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_SLAB);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitByAxeRecipe(recipeConsumer, Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitByChoppingRecipe(recipeConsumer, Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcFenceRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_FENCE);
        this.mcFenceRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_FENCE);
        this.mcFenceGateRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_FENCE_GATE);
        this.mcFenceGateRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_FENCE_GATE);
        this.mcDoorRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_DOOR);
        this.mcDoorRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_DOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_TRAPDOOR);
        this.mcTrapdoorRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_TRAPDOOR);
        this.mcPressurePlateRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_PRESSURE_PLATE);
        this.mcButtonRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_BUTTON);
        this.mcButtonRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_BUTTON);
        this.mcStairsRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_SLAB, Items.ACACIA_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_SLAB, Items.BIRCH_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_SLAB, Items.CHERRY_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB, Items.JUNGLE_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_SLAB, Items.OAK_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB, Items.DARK_OAK_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB, Items.MANGROVE_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB, Items.SPRUCE_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB, Items.CRIMSON_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB, Items.BAMBOO_STAIRS);
        this.mcStairsRecipe(recipeConsumer, Items.WARPED_PLANKS, Items.WARPED_SLAB, Items.WARPED_STAIRS);
        this.mcBedRecipe(recipeConsumer, Items.BLACK_WOOL, Items.BLACK_BED);
        this.mcBedRecipe(recipeConsumer, Items.BLUE_WOOL, Items.BLUE_BED);
        this.mcBedRecipe(recipeConsumer, Items.BROWN_WOOL, Items.BROWN_BED);
        this.mcBedRecipe(recipeConsumer, Items.WHITE_WOOL, Items.WHITE_BED);
        this.mcBedRecipe(recipeConsumer, Items.CYAN_WOOL, Items.CYAN_BED);
        this.mcBedRecipe(recipeConsumer, Items.GRAY_WOOL, Items.GRAY_BED);
        this.mcBedRecipe(recipeConsumer, Items.GREEN_WOOL, Items.GREEN_BED);
        this.mcBedRecipe(recipeConsumer, Items.LIME_WOOL, Items.LIME_BED);
        this.mcBedRecipe(recipeConsumer, Items.MAGENTA_WOOL, Items.MAGENTA_BED);
        this.mcBedRecipe(recipeConsumer, Items.ORANGE_WOOL, Items.ORANGE_BED);
        this.mcBedRecipe(recipeConsumer, Items.PINK_WOOL, Items.PINK_BED);
        this.mcBedRecipe(recipeConsumer, Items.PURPLE_WOOL, Items.PURPLE_BED);
        this.mcBedRecipe(recipeConsumer, Items.RED_WOOL, Items.RED_BED);
        this.mcBedRecipe(recipeConsumer, Items.YELLOW_WOOL, Items.YELLOW_BED);
        this.mcBedRecipe(recipeConsumer, Items.LIGHT_BLUE_WOOL, Items.LIGHT_BLUE_BED);
        this.mcBedRecipe(recipeConsumer, Items.LIGHT_GRAY_WOOL, Items.LIGHT_GRAY_BED);
        this.mcBoatRecipe(recipeConsumer, Items.ACACIA_PLANKS, Items.ACACIA_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.BIRCH_PLANKS, Items.BIRCH_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.CHERRY_PLANKS, Items.CHERRY_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.JUNGLE_PLANKS, Items.JUNGLE_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.OAK_PLANKS, Items.OAK_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.DARK_OAK_PLANKS, Items.DARK_OAK_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.MANGROVE_PLANKS, Items.MANGROVE_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.SPRUCE_PLANKS, Items.SPRUCE_BOAT);
        this.mcBoatRecipe(recipeConsumer, Items.BAMBOO_PLANKS, Items.BAMBOO_RAFT);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.ANDESITE, Items.ANDESITE_SLAB);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.COBBLESTONE, Items.COBBLESTONE_SLAB);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.DIORITE, Items.DIORITE_SLAB);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.GRANITE, Items.GRANITE_SLAB);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.SMOOTH_STONE, Items.SMOOTH_STONE_SLAB);
        this.mcSplitByHammerRecipe(recipeConsumer, Items.STONE, Items.STONE_SLAB);
        this.mcHorseArmorRecipe(recipeConsumer, Items.LEATHER, Items.LEATHER_HORSE_ARMOR);
        this.mcHorseArmorRecipe(recipeConsumer, MaterialType.GOLD, Items.GOLDEN_HORSE_ARMOR);
        this.mcHorseArmorRecipe(recipeConsumer, MaterialType.IRON, Items.IRON_HORSE_ARMOR);
        this.mcCookingRecipe(recipeConsumer, RecipeCategory.FOOD, YTechItemTags.BREAD_DOUGHS, Items.BREAD, 0.1f, 200);
        this.mcCookingRecipe(recipeConsumer, RecipeCategory.MISC, YTechItemTags.UNFIRED_BRICKS, Items.BRICK, 0.3f, 200);
        this.mcBowRecipe(recipeConsumer);
        this.mcBowlRecipe(recipeConsumer);
        this.mcIronBarsRecipe(recipeConsumer);
        this.mcIronDoorRecipe(recipeConsumer);
        this.mcIronTrapdoorRecipe(recipeConsumer);
        this.mcHeavyWeightedPressurePlateRecipe(recipeConsumer);
        this.mcLightWeightedPressurePlateRecipe(recipeConsumer);
        this.mcChainRecipe(recipeConsumer);
        this.mcLanternRecipe(recipeConsumer);
        this.mcSoulLanternRecipe(recipeConsumer);
        this.mcFishingRodRecipe(recipeConsumer);
        this.mcLeadRecipe(recipeConsumer);
        this.mcSaddleRecipe(recipeConsumer);
        this.mcBoneMealRecipe(recipeConsumer);
        this.mcCookieRecipe(recipeConsumer);
        this.mcCakeRecipe(recipeConsumer);
        this.mcTripwireHookRecipe(recipeConsumer);
        this.mcCrossbowRecipe(recipeConsumer);
        this.mcCampfireRecipe(recipeConsumer);
        this.mcSoulCampfireRecipe(recipeConsumer);
        this.mcMudRecipe(recipeConsumer);
        YTechRecipeProvider.registerBasketRecipe(recipeConsumer);
        YTechRecipeProvider.registerBeeswaxRecipe(recipeConsumer);
        YTechRecipeProvider.registerBoneNeedleRecipe(recipeConsumer);
        YTechRecipeProvider.registerBreadDoughRecipe(recipeConsumer);
        YTechRecipeProvider.registerBrickMoldRecipe(recipeConsumer);
        YTechRecipeProvider.registerCookedVenisonRecipe(recipeConsumer);
        YTechRecipeProvider.registerDiviningRodRecipe(recipeConsumer);
        YTechRecipeProvider.registerFlourRecipe(recipeConsumer);
        YTechRecipeProvider.registerGrassTwineRecipe(recipeConsumer);
        YTechRecipeProvider.registerIronBloomRecipe(recipeConsumer);
        YTechRecipeProvider.registerLeatherStripsRecipe(recipeConsumer);
        YTechRecipeProvider.registerRawHideRecipe(recipeConsumer);
        YTechRecipeProvider.registerUnfiredBrickRecipe(recipeConsumer);
        YTechRecipeProvider.registerUnlitTorchRecipe(recipeConsumer);
        YTechRecipeProvider.registerVenusOfHohleFelsRecipe(recipeConsumer);
        YTechRecipeProvider.registerLionManRecipe(recipeConsumer);
        YTechRecipeProvider.registerWildHorseRecipe(recipeConsumer);
        YTechRecipeProvider.registerShellBeadsRecipe(recipeConsumer);
        YTechRecipeProvider.registerChloriteBraceletRecipe(recipeConsumer);
        YTechItems.CLAY_MOLDS.forEach((part, item) -> this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.UNFIRED_MOLDS.get(part)), (Item)item.get(), 1000, 200));
        YTechItems.PATTERNS.forEach((type, item) -> YTechRecipeProvider.registerPatternRecipe(recipeConsumer, (DeferredItem<Item>)item, type));
        YTechItems.SAND_MOLDS.forEach((type, item) -> YTechRecipeProvider.registerSandMoldRecipe(recipeConsumer, (DeferredItem<Item>)item, type));
        YTechItems.UNFIRED_MOLDS.forEach((part, item) -> YTechRecipeProvider.registerUnfiredMoldRecipe(recipeConsumer, (DeferredItem<Item>)item, part));
        YTechItems.PARTS.forEach((material, map) -> map.forEach((part, item) -> this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(material)), part.ingotCount, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(part)), (Item)item.get(), material.meltingTemp, 200 * part.ingotCount, "mold")));
        YTechItems.ARROWS.forEach((material, item) -> YTechRecipeProvider.registerArrowRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.AXES.forEach((material, item) -> YTechRecipeProvider.registerAxeRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.BOLTS.forEach((material, item) -> YTechRecipeProvider.registerBoltRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.BOOTS.forEach((material, item) -> YTechRecipeProvider.registerBootsRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.CHESTPLATES.forEach((material, item) -> YTechRecipeProvider.registerChestplateRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.CRUSHED_MATERIALS.forEach((material, item) -> YTechRecipeProvider.registerCrushedRawMaterialRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.FILES.forEach((material, item) -> YTechRecipeProvider.registerFileRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.HAMMERS.forEach((material, item) -> YTechRecipeProvider.registerHammerRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.HELMETS.forEach((material, item) -> YTechRecipeProvider.registerHelmetRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.HOES.forEach((material, item) -> YTechRecipeProvider.registerHoeRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.INGOTS.forEach((material, item) -> YTechRecipeProvider.registerIngotRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.KNIVES.forEach((material, item) -> YTechRecipeProvider.registerKnifeRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.LEGGINGS.forEach((material, item) -> YTechRecipeProvider.registerLeggingsRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.MESHES.forEach((material, item) -> YTechRecipeProvider.registerMeshRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.MORTAR_AND_PESTLES.forEach((material, item) -> YTechRecipeProvider.registerMortarAndPestleRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.PICKAXES.forEach((material, item) -> YTechRecipeProvider.registerPickaxeRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.PLATES.forEach((material, item) -> YTechRecipeProvider.registerPlateRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.RAW_MATERIALS.forEach((material, item) -> YTechRecipeProvider.registerRawMaterialRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.RODS.forEach((material, item) -> YTechRecipeProvider.registerRodRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SAWS.forEach((material, item) -> YTechRecipeProvider.registerSawRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SAW_BLADES.forEach((material, item) -> YTechRecipeProvider.registerSawBladeRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SHEARS.forEach((material, item) -> YTechRecipeProvider.registerShearsRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SHOVELS.forEach((material, item) -> YTechRecipeProvider.registerShovelRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SPEARS.forEach((material, item) -> YTechRecipeProvider.registerSpearRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.SWORDS.forEach((key, item) -> YTechRecipeProvider.registerSwordRecipe(recipeConsumer, (DeferredItem<Item>)item, key));
        AqueductFertilizerBlock.registerRecipe(recipeConsumer);
        AqueductHydratorBlock.registerRecipe(recipeConsumer);
        AqueductValveBlock.registerRecipe(recipeConsumer);
        BrickChimneyBlock.registerRecipe(recipeConsumer);
        BronzeAnvilBlock.registerRecipe(recipeConsumer);
        CraftingWorkspaceBlock.registerRecipe(recipeConsumer);
        FirePitBlock.registerRecipe(recipeConsumer);
        GrassBedBlock.registerRecipe(recipeConsumer);
        MillstoneBlock.registerRecipe(recipeConsumer);
        PottersWheelBlock.registerRecipe(recipeConsumer);
        PrimitiveAlloySmelterBlock.registerRecipe(recipeConsumer);
        PrimitiveSmelterBlock.registerRecipe(recipeConsumer);
        YTechRecipeProvider.registerReinforcedBricksRecipe(recipeConsumer);
        ReinforcedBrickChimneyBlock.registerRecipe(recipeConsumer);
        YTechRecipeProvider.registerStrainerRecipe(recipeConsumer);
        YTechRecipeProvider.registerTerracottaBricksRecipe(recipeConsumer);
        YTechRecipeProvider.registerTerracottaBrickSlabRecipe(recipeConsumer);
        YTechRecipeProvider.registerTerracottaBrickStairsRecipe(recipeConsumer);
        YTechRecipeProvider.registerThatchBlockRecipe(recipeConsumer);
        YTechRecipeProvider.registerThatchBlockSlabRecipe(recipeConsumer);
        YTechRecipeProvider.registerThatchBlockStairsRecipe(recipeConsumer);
        YTechRecipeProvider.registerTreeStumpRecipe(recipeConsumer);
        YTechItems.AQUEDUCTS.forEach((material, item) -> AqueductBlock.registerRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.DRYING_RACKS.forEach((material, item) -> DryingRackBlock.registerRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.RAW_STORAGE_BLOCKS.forEach((material, item) -> YTechRecipeProvider.registerRawStorageBlockRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.STORAGE_BLOCKS.forEach((material, item) -> YTechRecipeProvider.registerStorageBlockRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        YTechItems.TANNING_RACKS.forEach((material, item) -> TanningRackBlock.registerRecipe(recipeConsumer, (DeferredItem<Item>)item, material));
        this.alloyingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(MaterialType.COPPER)), 9, (TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(MaterialType.TIN)), 1, (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.BRONZE)).get(), 10, Math.max(MaterialType.COPPER.meltingTemp, MaterialType.TIN.meltingTemp), 200);
        this.alloyingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GALENA)), 1, (TagKey<Item>)ItemTags.SMELTS_TO_GLASS, 1, Items.GLASS, 1, 800, 200);
        this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.COPPER)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), Items.COPPER_INGOT, MaterialType.COPPER.meltingTemp, 200, "smelting");
        this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GOLD)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), Items.GOLD_INGOT, MaterialType.GOLD.meltingTemp, 200, "smelting");
        this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.CASSITERITE)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.TIN)).get(), MaterialType.CASSITERITE.meltingTemp, 200, "smelting");
        this.smeltingRecipe(recipeConsumer, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GALENA)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.LEAD)).get(), MaterialType.GALENA.meltingTemp, 200, "smelting");
        this.smeltingRecipe(recipeConsumer, YTechItemTags.UNFIRED_CLAY_BUCKETS, (Item)YTechItems.CLAY_BUCKET.get(), 1000, 200);
        this.smeltingRecipe(recipeConsumer, YTechItemTags.UNFIRED_DECORATED_POTS, Items.DECORATED_POT, 1000, 200);
        this.smeltingRecipe(recipeConsumer, YTechItemTags.UNFIRED_FLOWER_POTS, Items.FLOWER_POT, 1000, 200);
        this.smeltingRecipe(recipeConsumer, YTechItemTags.UNFIRED_AMPHORAE, (Item)YTechItems.AMPHORA.get(), 1000, 200);
        this.smeltingRecipe(recipeConsumer, (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL, Items.STONE, 1300, 200);
        this.hammeringRecipe(recipeConsumer, YTechItemTags.IRON_BLOOMS, 4, Items.IRON_INGOT);
        this.registerBlockHitRecipe(recipeConsumer, Items.FLINT, (TagKey<Item>)Tags.Items.STONES, (Item)YTechItems.SHARP_FLINT.get());
        this.registerBlockHitRecipe(recipeConsumer, (Item)YTechItems.UNLIT_TORCH.get(), YTechItemTags.FIRE_SOURCE, Items.TORCH);
        this.registerBlockHitRecipe(recipeConsumer, (Item)YTechItems.UNLIT_TORCH.get(), YTechItemTags.SOUL_FIRE_SOURCE, Items.SOUL_TORCH);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.BEEF, YTechItems.DRIED_BEEF);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.CHICKEN, YTechItems.DRIED_CHICKEN);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.COD, YTechItems.DRIED_COD);
        this.registerDryingRecipe(recipeConsumer, Items.KELP, Items.DRIED_KELP, 1200);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.MUTTON, YTechItems.DRIED_MUTTON);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.PORKCHOP, YTechItems.DRIED_PORKCHOP);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.RABBIT, YTechItems.DRIED_RABBIT);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, Items.SALMON, YTechItems.DRIED_SALMON);
        YTechRecipeProvider.registerDryingRecipe(recipeConsumer, YTechItemTags.VENISON, YTechItems.DRIED_VENISON);
        this.crushingRecipe(recipeConsumer, YTechItemTags.ANTLERS, Items.BONE_MEAL, 2, "_from_" + Utils.getPath(YTechItems.ANTLER));
        this.crushingRecipe(recipeConsumer, YTechItemTags.MAMMOTH_TUSKS, Items.BONE_MEAL, 5, "_from_" + Utils.getPath(YTechItems.MAMMOTH_TUSK));
        this.crushingRecipe(recipeConsumer, YTechItemTags.RHINO_HORNS, Items.BONE_MEAL, 3, "_from_" + Utils.getPath(YTechItems.RHINO_HORN));
        this.potteryRecipe(recipeConsumer, 2, YTechItems.UNFIRED_FLOWER_POT);
        this.potteryRecipe(recipeConsumer, 3, YTechItems.UNFIRED_CLAY_BUCKET);
        this.potteryRecipe(recipeConsumer, 4, YTechItems.UNFIRED_DECORATED_POT);
        this.potteryRecipe(recipeConsumer, 5, YTechItems.UNFIRED_AMPHORA);
        YTechRecipeProvider.wcChestRecipe(recipeConsumer);
        YTechRecipeProvider.wcFurnaceRecipe(recipeConsumer);
        YTechRecipeProvider.wcCraftingTableRecipe(recipeConsumer);
        YTechRecipeProvider.wcStonecutterRecipe(recipeConsumer);
        YTechRecipeProvider.wcBarrelRecipe(recipeConsumer);
        YTechRecipeProvider.wcFletchingTableRecipe(recipeConsumer);
        YTechRecipeProvider.wcCartographyTableRecipe(recipeConsumer);
        YTechRecipeProvider.wcSmithingTableRecipe(recipeConsumer);
        YTechRecipeProvider.wcGrindstoneRecipe(recipeConsumer);
        YTechRecipeProvider.wcLoomRecipe(recipeConsumer);
        YTechRecipeProvider.wcSmokerRecipe(recipeConsumer);
        YTechRecipeProvider.wcComposterRecipe(recipeConsumer);
        YTechRecipeProvider.wcWoodenBoxRecipe(recipeConsumer);
        YTechRecipeProvider.wcToolRackRecipe(recipeConsumer);
        YTechRecipeProvider.wcWellPulleyRecipe(recipeConsumer);
        this.removeVanillaRecipes(recipeConsumer);
    }

    private void removeVanillaRecipes(@NotNull RecipeOutput recipeConsumer) {
        this.removeVanillaRecipe(recipeConsumer, Items.WOODEN_AXE);
        this.removeVanillaRecipe(recipeConsumer, Items.WOODEN_HOE);
        this.removeVanillaRecipe(recipeConsumer, Items.WOODEN_PICKAXE);
        this.removeVanillaRecipe(recipeConsumer, Items.WOODEN_SWORD);
        this.removeVanillaRecipe(recipeConsumer, Items.STONE_AXE);
        this.removeVanillaRecipe(recipeConsumer, Items.STONE_PICKAXE);
        this.removeVanillaRecipe(recipeConsumer, Items.STONE_SHOVEL);
        this.removeVanillaRecipe(recipeConsumer, Items.STONE_SWORD);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.COPPER_INGOT, Items.RAW_COPPER);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.COPPER_INGOT, Items.COPPER_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.COPPER_INGOT, Items.DEEPSLATE_COPPER_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.GOLD_INGOT, Items.RAW_GOLD);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.GOLD_INGOT, Items.GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.GOLD_INGOT, Items.DEEPSLATE_GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.GOLD_INGOT, Items.NETHER_GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.IRON_INGOT, Items.RAW_IRON);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.IRON_INGOT, Items.IRON_ORE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.IRON_INGOT, Items.DEEPSLATE_IRON_ORE);
        this.removeVanillaRecipe(recipeConsumer, Items.GLASS);
        this.removeVanillaRecipe(recipeConsumer, Items.STONE);
        this.removeVanillaSmeltingBlastingRecipe(recipeConsumer, Items.STONE, Items.COBBLESTONE);
        this.removeVanillaRecipe(recipeConsumer, Items.FLOWER_POT);
        this.removeVanillaRecipe(recipeConsumer, Items.TORCH);
        this.removeVanillaRecipe(recipeConsumer, Items.SOUL_TORCH);
        this.removeVanillaRecipe(recipeConsumer, Items.CRAFTING_TABLE);
        this.removeVanillaRecipe(recipeConsumer, Items.FURNACE);
        this.removeVanillaRecipe(recipeConsumer, Items.SMOKER);
        this.removeVanillaRecipe(recipeConsumer, Items.FLETCHING_TABLE);
        this.removeVanillaRecipe(recipeConsumer, Items.CARTOGRAPHY_TABLE);
        this.removeVanillaRecipe(recipeConsumer, Items.STONECUTTER);
        this.removeVanillaRecipe(recipeConsumer, Items.SMITHING_TABLE);
        this.removeVanillaRecipe(recipeConsumer, Items.GRINDSTONE);
        this.removeVanillaRecipe(recipeConsumer, Items.LOOM);
        this.removeVanillaRecipe(recipeConsumer, Items.CHEST);
        this.removeVanillaRecipe(recipeConsumer, Items.BARREL);
        this.removeVanillaRecipe(recipeConsumer, Items.COMPOSTER);
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(recipeConsumer, Utils.mcLoc("decorated_pot_simple").toString());
    }

    private void removeVanillaRecipe(@NotNull RecipeOutput recipeConsumer, Item item) {
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(recipeConsumer, Utils.loc(item).toString());
    }

    private void removeVanillaSmeltingBlastingRecipe(@NotNull RecipeOutput recipeConsumer, Item to, Item from) {
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(recipeConsumer, Utils.mcLoc(Utils.loc(to).getPath() + "_from_smelting_" + Utils.loc(from).getPath()).toString());
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(recipeConsumer, Utils.mcLoc(Utils.loc(to).getPath() + "_from_blasting_" + Utils.loc(from).getPath()).toString());
    }

    private void mcSplitBySawRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, 3).requires((ItemLike)input).requires(YTechItemTags.SAWS.tag).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), RecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcSplitByChoppingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull Item result) {
        ChoppingRecipe.Builder.chopping((ItemLike)input, YTechItemTags.AXES.tag, 3, result, 2).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), RecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + "_from_chopping"));
    }

    private void mcSplitByAxeRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires((ItemLike)input).requires(YTechItemTags.AXES.tag).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), RecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath()));
    }

    private void mcSplitByHammerRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires((ItemLike)input).requires(YTechItemTags.HAMMERS.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)input), RecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcFenceRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.DECORATIONS, (ItemLike)result, 2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("H W").pattern("PSP").pattern("PSP").group("wooden_fence").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), YTechRecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcFenceGateRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)result, 2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("H W").pattern("BPB").pattern("SPS").group("wooden_fence_gate").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), YTechRecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcDoorRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern("PPH").pattern("PPB").pattern("PPW").group("wooden_door").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcTrapdoorRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)result, 2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern("HBW").pattern("PPP").pattern("PPP").group("wooden_trapdoor").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcPressurePlateRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)result).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern(" W ").pattern("PPP").pattern("BBB").group("wooden_pressure_plate").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcButtonRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.REDSTONE, (ItemLike)result).requires(YTechItemTags.SAWS.tag).requires((TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).requires((ItemLike)planks).group("wooden_button").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcStairsRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item slab, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, 2).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).pattern("PW").pattern("BB").pattern("SS").group("wooden_stairs").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcBedRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item wool, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.DECORATIONS, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('P'), ItemTags.WOODEN_SLABS).pattern("H S").pattern("WWW").pattern("PPP").group("bed").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.WOOL)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcBoatRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TRANSPORTATION, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).define(Character.valueOf('F'), YTechItemTags.FILES.tag).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), (ItemLike)planks).pattern("HFS").pattern("PIP").pattern("PPP").group("boat").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcHorseArmorRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item item, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)item).define(Character.valueOf('X'), (ItemLike)Items.SADDLE).pattern("L#L").pattern("LXL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, Utils.loc(result));
    }

    private void mcHorseArmorRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull MaterialType material, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('#'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('X'), (ItemLike)Items.SADDLE).pattern("L#L").pattern("LXL").pattern("LSL").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, Utils.loc(result));
    }

    private void mcSoulCampfireRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.SOUL_CAMPFIRE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('T'), (ItemLike)Items.SOUL_TORCH).pattern(" S ").pattern("STS").pattern("LLL").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.SOUL_TORCH), YTechRecipeProvider.has((ItemLike)Items.SOUL_TORCH)).save(recipeConsumer, Utils.loc(Items.SOUL_CAMPFIRE));
    }

    private void mcMudRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.MUD, (int)3).requires((ItemLike)Items.DIRT, 3).requires(YTechItemTags.WATER_BUCKETS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.DIRT), YTechRecipeProvider.has((ItemLike)Items.DIRT)).save(recipeConsumer, Utils.modLoc(Items.MUD));
    }

    private void mcCampfireRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.CAMPFIRE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('T'), (ItemLike)Items.TORCH).pattern(" S ").pattern("STS").pattern("LLL").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.TORCH), YTechRecipeProvider.has((ItemLike)Items.TORCH)).save(recipeConsumer, Utils.loc(Items.CAMPFIRE));
    }

    private void mcCrossbowRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CROSSBOW).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('$'), (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('&'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('~'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('F'), YTechItemTags.KNIVES.tag).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#&#").pattern("~$~").pattern("FSH").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((ItemLike)Items.TRIPWIRE_HOOK)).save(recipeConsumer, Utils.loc(Items.CROSSBOW));
    }

    private void mcTripwireHookRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).pattern("IH").pattern("S ").pattern("L ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.TRIPWIRE_HOOK));
    }

    private void mcCakeRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CAKE).define(Character.valueOf('A'), YTechItemTags.FLOURS).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('D'), (ItemLike)Items.EGG).pattern("CCC").pattern("BDB").pattern("AAA").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(YTechItemTags.FLOURS)).save(recipeConsumer, Utils.loc(Items.CAKE));
    }

    private void mcCookieRecipe(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COOKIE, (int)8).define(Character.valueOf('#'), YTechItemTags.FLOURS).define(Character.valueOf('X'), (ItemLike)Items.COCOA_BEANS).pattern("#X#").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(YTechItemTags.FLOURS)).save(recipeConsumer, Utils.loc(Items.COOKIE));
    }

    private void mcBoneMealRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BONE), RecipeProvider.has((ItemLike)Items.BONE)).save(recipeConsumer, Utils.loc(Items.BONE_MEAL));
        MillingRecipe.Builder.milling((ItemLike)Items.BONE, Items.BONE_MEAL, 2).bonusChance(0.2f).unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.BONE)).save(recipeConsumer, Utils.modLoc(Utils.loc(Items.BONE_MEAL).getPath() + "_from_milling"));
    }

    private void mcSaddleRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)Items.SADDLE).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('K'), YTechItemTags.KNIVES.tag).pattern("LLL").pattern("LSL").pattern("HIK").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, Utils.loc(Items.SADDLE));
    }

    private void mcLeadRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)Items.LEAD).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("LL ").pattern("LS ").pattern("  L").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(YTechItemTags.LEATHER_STRIPS)).save(recipeConsumer, Utils.loc(Items.LEAD));
    }

    private void mcFishingRodRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)Items.FISHING_ROD).define(Character.valueOf('B'), YTechItemTags.BOLTS.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), Tags.Items.STRINGS).pattern("  S").pattern(" ST").pattern("S B").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.loc(Items.FISHING_ROD));
    }

    private void mcSoulLanternRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)Items.SOUL_LANTERN).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), YTechItemTags.PLATES.tag).define(Character.valueOf('T'), (ItemLike)Items.SOUL_TORCH).pattern(" P ").pattern("ITI").pattern(" P ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.SOUL_LANTERN));
    }

    private void mcLanternRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)Items.LANTERN).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), YTechItemTags.PLATES.tag).define(Character.valueOf('T'), (ItemLike)Items.TORCH).pattern(" P ").pattern("ITI").pattern(" P ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.LANTERN));
    }

    private void mcChainRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)Items.CHAIN).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).pattern("IW").pattern("I ").pattern("I ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.CHAIN));
    }

    private void mcLightWeightedPressurePlateRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.GOLD)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.GOLD)).pattern(" W ").pattern("PPP").pattern("BBB").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.GOLD)))).save(recipeConsumer, Utils.loc(Items.LIGHT_WEIGHTED_PRESSURE_PLATE));
    }

    private void mcHeavyWeightedPressurePlateRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).pattern(" W ").pattern("PPP").pattern("BBB").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.HEAVY_WEIGHTED_PRESSURE_PLATE));
    }

    private void mcIronTrapdoorRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)Items.IRON_TRAPDOOR, 2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).pattern("HB ").pattern("PPP").pattern("PPP").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.IRON_TRAPDOOR));
    }

    private void mcIronDoorRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.REDSTONE, (ItemLike)Items.IRON_DOOR).define(Character.valueOf('C'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).pattern("CCH").pattern("CCB").pattern("CC ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.IRON_DOOR));
    }

    private void mcIronBarsRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.DECORATIONS, (ItemLike)Items.IRON_BARS).define(Character.valueOf('C'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).pattern("CCC").pattern("CCC").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.loc(Items.IRON_BARS));
    }

    private void mcBowlRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)Items.BOWL).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("P#P").pattern(" P ").unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.loc(Items.BOWL));
    }

    private void mcBowRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)Items.BOW).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), Tags.Items.STRINGS).pattern(" SW").pattern("S#W").pattern(" SW").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), YTechRecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.loc(Items.BOW));
    }

    private void smeltingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull TagKey<Item> input, @NotNull Item result, int temperature, int smeltingTime) {
        SmeltingRecipe.Builder.smelting(input, temperature, smeltingTime, result).unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + "_from_smelting"));
    }

    private void smeltingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull TagKey<Item> input, int inputCount, TagKey<Item> mold, @NotNull Item result, int temperature, int smeltingTime, String from) {
        SmeltingRecipe.Builder.smelting(input, inputCount, mold, temperature, smeltingTime, result).unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + "_from_" + from));
    }

    private void registerBlockHitRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull TagKey<Item> block, @NotNull Item result) {
        BlockHitRecipe.Builder.blockUse((ItemLike)input, block, result).unlockedBy(Utils.getHasName(), YTechRecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath()));
    }

    private void mcCookingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull RecipeCategory category, @NotNull TagKey<Item> input, @NotNull Item result, float xp, int cookingTime) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(input), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)cookingTime).unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(input)).save(recipeConsumer, Utils.loc(result));
    }

    private void alloyingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull TagKey<Item> input1, int count1, @NotNull TagKey<Item> input2, int count2, @NotNull Item result, int count, int temp, int smeltingTime) {
        AlloyingRecipe.Builder.alloying(input1, count1, input2, count2, temp, smeltingTime, result, count).unlockedBy(Utils.getHasName(), YTechRecipeProvider.has(input1)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + "_from_alloying"));
    }

    private void registerDryingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull Item input, @NotNull Item result, int dryingTime) {
        DryingRecipe.Builder.drying((ItemLike)input, dryingTime, result).unlockedBy(RecipeProvider.getHasName((ItemLike)input), YTechRecipeProvider.has((ItemLike)input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath()));
    }

    private void hammeringRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull TagKey<Item> input, int hitCount, @NotNull Item result) {
        HammeringRecipe.Builder.hammering(input, hitCount, result).tool(Ingredient.of(YTechItemTags.HAMMERS.tag)).unlockedBy(Utils.getHasName(), RecipeProvider.has(input)).save(recipeConsumer, Utils.modLoc(result));
    }

    private void crushingRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull TagKey<Item> input, @NotNull Item result, int count, String suffix) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)result, count).requires(input).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has(input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + suffix));
        MillingRecipe.Builder.milling(input, result, count + (int)Math.ceil((double)count / 2.0)).bonusChance(0.2f).unlockedBy(Utils.getHasName(), RecipeProvider.has(input)).save(recipeConsumer, Utils.modLoc(Utils.loc(result).getPath() + suffix + "_from_milling"));
    }

    private void potteryRecipe(@NotNull RecipeOutput recipeConsumer, int count, DeferredItem<Item> result) {
        PotteryRecipe.Builder.pottery(count, (Item)result.get()).unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeConsumer, Utils.modLoc(result));
    }

    private static void registerGrassTwineRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.GRASS_TWINE.get()).define(Character.valueOf('#'), YTechItemTags.GRASS_FIBERS).pattern("##").pattern("##").unlockedBy(Utils.getHasItem(YTechItems.GRASS_FIBERS), RecipeProvider.has(YTechItemTags.GRASS_FIBERS)).save(recipeConsumer, YTechItems.GRASS_TWINE.getId());
    }

    private static void registerBrickMoldRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.BRICK_MOLD.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN)).define(Character.valueOf('I'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).pattern("I#I").pattern("###").pattern("I#I").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN)))).save(recipeConsumer, YTechItems.BRICK_MOLD.getId());
    }

    private static void registerRawHideRecipe(RecipeOutput recipeConsumer) {
        TanningRecipe.Builder.tanning(YTechItemTags.RAW_HIDES, 5, Items.LEATHER).tool(Ingredient.of(YTechItemTags.SHARP_FLINTS)).unlockedBy(Utils.getHasItem(YTechItems.RAW_HIDE), RecipeProvider.has(YTechItemTags.RAW_HIDES)).save(recipeConsumer, YTechItems.RAW_HIDE.getId());
    }

    private static void registerLeatherStripsRecipe(RecipeOutput recipeConsumer) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)YTechItems.LEATHER_STRIPS.get(), 4).requires((ItemLike)Items.LEATHER).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.LEATHER), RecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, YTechItems.LEATHER_STRIPS.getId());
    }

    private static void registerIronBloomRecipe(RecipeOutput recipeConsumer) {
        AlloyingRecipe.Builder.alloying((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.IRON)), 1, (ItemLike)Items.CHARCOAL, 1, 1250, 200, (Item)YTechItems.IRON_BLOOM.get(), 1).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.IRON)))).save(recipeConsumer, YTechItems.IRON_BLOOM.getId());
    }

    private static void registerUnfiredBrickRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.UNFIRED_BRICK.get(), 8).define(Character.valueOf('#'), YTechItemTags.BRICK_MOLDS).define(Character.valueOf('B'), (ItemLike)Items.CLAY_BALL).pattern("BBB").pattern("B#B").pattern("BBB").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.CLAY_BALL), RecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeConsumer, YTechItems.UNFIRED_BRICK.getId());
    }

    private static void registerUnlitTorchRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.UNLIT_TORCH.get(), 4).define(Character.valueOf('#'), ItemTags.COALS).define(Character.valueOf('B'), (ItemLike)Items.STICK).pattern("#").pattern("B").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.COALS)).save(recipeConsumer, YTechItems.UNLIT_TORCH.getId());
    }

    private static void registerVenusOfHohleFelsRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.VENUS_OF_HOHLE_FELS.get()).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T#").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.MAMMOTH_TUSKS)).save(recipeConsumer, YTechItems.VENUS_OF_HOHLE_FELS.getId());
    }

    private static void registerLionManRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.LION_MAN.get()).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T ").pattern(" #").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.MAMMOTH_TUSKS)).save(recipeConsumer, YTechItems.LION_MAN.getId());
    }

    private static void registerWildHorseRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.WILD_HORSE.get()).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T").pattern("#").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.MAMMOTH_TUSKS)).save(recipeConsumer, YTechItems.WILD_HORSE.getId());
    }

    private static void registerShellBeadsRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.SHELL_BEADS.get()).define(Character.valueOf('S'), (ItemLike)Items.NAUTILUS_SHELL).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('F'), YTechItemTags.SHARP_FLINTS).pattern("FL ").pattern("SSS").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.LEATHER_STRIPS)).save(recipeConsumer, YTechItems.SHELL_BEADS.getId());
    }

    private static void registerChloriteBraceletRecipe(RecipeOutput recipeConsumer) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)YTechItems.CHLORITE_BRACELET.get()).requires(YTechItemTags.PEBBLES).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.PEBBLES)).save(recipeConsumer, YTechItems.CHLORITE_BRACELET.getId());
    }

    private static void registerDryingRecipe(RecipeOutput recipeConsumer, Item rawMeat, DeferredItem<Item> output) {
        DryingRecipe.Builder.drying((ItemLike)rawMeat, 1200, (Item)output.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)rawMeat), RecipeProvider.has((ItemLike)rawMeat)).save(recipeConsumer, output.getId());
    }

    private static void registerDryingRecipe(RecipeOutput recipeConsumer, TagKey<Item> rawMeat, DeferredItem<Item> output) {
        DryingRecipe.Builder.drying(rawMeat, 1200, (Item)output.get()).unlockedBy(Utils.getHasItem(rawMeat), RecipeProvider.has(rawMeat)).save(recipeConsumer, output.getId());
    }

    private static void registerBasketRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.BASKET.get()).define(Character.valueOf('#'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('B'), YTechItemTags.BONE_NEEDLES).pattern(" # ").pattern("#B#").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.GRASS_TWINES)).save(recipeConsumer, YTechItems.BASKET.getId());
    }

    private static void registerBeeswaxRecipe(RecipeOutput recipeConsumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.BEESWAX.get()), (float)0.5f, (int)100).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.CLAY_BALL), RecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeConsumer, YTechItems.BEESWAX.getId());
    }

    private static void registerBoneNeedleRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.BONE_NEEDLE.get()).define(Character.valueOf('T'), Tags.Items.BONES).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("#T").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)Tags.Items.BONES)).save(recipeConsumer, YTechItems.BONE_NEEDLE.getId());
    }

    private static void registerKnifeRecipe(RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.FLINT) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires((ItemLike)Items.FLINT).requires(YTechItemTags.LEATHER_STRIPS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.FLINT), RecipeProvider.has((ItemLike)Items.FLINT)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).pattern("FP").pattern("S ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerCookedVenisonRecipe(RecipeOutput recipeConsumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(YTechItemTags.VENISON), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)200).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.VENISON)).save(recipeConsumer, YTechItems.COOKED_VENISON.getId());
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of(YTechItemTags.VENISON), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)600).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.VENISON)).save(recipeConsumer, Utils.modLoc(Utils.getPath(YTechItems.COOKED_VENISON) + "_using_campfire"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of(YTechItemTags.VENISON), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)100).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.VENISON)).save(recipeConsumer, Utils.modLoc(Utils.getPath(YTechItems.COOKED_VENISON) + "_using_smoker"));
    }

    private static void registerDiviningRodRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechItems.DIVINING_ROD.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('F'), YTechItemTags.SHARP_FLINTS).pattern("SS").pattern("TF").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.SHARP_FLINTS)).save(recipeConsumer, YTechItems.DIVINING_ROD.getId());
    }

    private static void registerFlourRecipe(RecipeOutput recipeConsumer) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)YTechItems.FLOUR.get()).requires(Tags.Items.CROPS_WHEAT).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), RecipeProvider.has((TagKey)Tags.Items.CROPS_WHEAT)).save(recipeConsumer, YTechItems.FLOUR.getId());
        MillingRecipe.Builder.milling((TagKey<Item>)Tags.Items.CROPS_WHEAT, (Item)YTechItems.FLOUR.get(), 2).bonusChance(0.5f).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), RecipeProvider.has((TagKey)Tags.Items.CROPS_WHEAT)).save(recipeConsumer, Utils.modLoc(Utils.getPath(YTechItems.FLOUR) + "_from_milling"));
    }

    private static void registerBreadDoughRecipe(@NotNull RecipeOutput recipeConsumer) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)YTechItems.BREAD_DOUGH.get()).requires(YTechItemTags.FLOURS).requires(YTechItemTags.FLOURS).requires(YTechItemTags.FLOURS).requires(YTechItemTags.WATER_BUCKETS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), RecipeProvider.has((TagKey)Tags.Items.CROPS_WHEAT)).save(recipeConsumer, YTechItems.BREAD_DOUGH.getId());
    }

    public static void registerPatternRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, PartType partType) {
        switch (partType) {
            case AXE_HEAD: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("#").pattern("P").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), RecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(recipeConsumer, item.getId());
                break;
            }
            case HAMMER_HEAD: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern(" #").pattern("P ").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), RecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(recipeConsumer, item.getId());
                break;
            }
            case PICKAXE_HEAD: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), RecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(recipeConsumer, item.getId());
                break;
            }
            case SWORD_BLADE: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P ").pattern(" #").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), RecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(recipeConsumer, item.getId());
                break;
            }
            case INGOT: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P").pattern("#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), RecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(recipeConsumer, item.getId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Missing recipe");
            }
        }
    }

    public static void registerSandMoldRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, PartType partType) {
        if (partType == PartType.INGOT) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)item.get()).requires(ItemTags.SAND).requires(YTechItemTags.INGOTS.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.SAND)).save(recipeConsumer, item.getId());
        } else {
            RemainingPartShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)item.get()).requires(ItemTags.SAND).requires(YTechItemTags.PARTS.getSubType(partType)).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.SAND)).save(recipeConsumer, item.getId());
        }
    }

    public static void registerUnfiredMoldRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, PartType partType) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).requires((ItemLike)Items.CLAY).requires((TagKey)YTechItemTags.PATTERNS.get(partType)).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.CLAY), RecipeProvider.has((ItemLike)Items.CLAY)).save(recipeConsumer, item.getId());
    }

    public static void registerArrowRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).define(Character.valueOf('#'), (TagKey)YTechItemTags.BOLTS.get(material)).pattern("#").pattern("S").pattern("F").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.BOLTS.get(material)))).save(recipeConsumer, item.getId());
    }

    private static void registerAxeRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case FLINT: {
                RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires((ItemLike)Items.FLINT).requires(YTechItemTags.GRASS_TWINES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), RecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, item.getId());
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("##H").pattern("#S ").pattern(" S ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.AXE_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
            }
        }
    }

    private static void registerBoltRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)).get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.AXES.tag).group(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), RecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.modLoc(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN)) + "_using_axe"));
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)).get(), 2).requires((ItemLike)Items.STICK).requires(YTechItemTags.SAWS.tag).group(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), RecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, Utils.modLoc(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN)) + "_using_saw"));
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).define(Character.valueOf('#'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).pattern("# ").pattern(" S").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RODS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerBootsRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern(" # ").pattern("LSL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("#H#").pattern("# #").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerChestplateRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("L#L").pattern("LSL").pattern("LLL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("#H#").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerCrushedRawMaterialRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)item.get()).requires((TagKey)YTechItemTags.RAW_MATERIALS.get(material)).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RAW_MATERIALS.get(material)))).save(recipeConsumer, item.getId());
        MillingRecipe.Builder.milling((TagKey<Item>)((TagKey)YTechItemTags.RAW_MATERIALS.get(material)), (Item)item.get(), 1).bonusChance(0.5f).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RAW_MATERIALS.get(material)))).save(recipeConsumer, Utils.modLoc(Utils.getPath(item) + "_from_milling"));
    }

    public static void registerFileRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("S").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
    }

    public static void registerHammerRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case STONE: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('#'), YTechItemTags.PEBBLES).pattern(" #T").pattern(" S#").pattern("S  ").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.LEATHER_STRIPS)).save(recipeConsumer, item.getId());
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)).pattern(" # ").pattern(" S#").pattern("S  ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)))).save(recipeConsumer, item.getId());
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.HAMMER_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
            }
        }
    }

    public static void registerHelmetRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern(" # ").pattern("LLL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("###").pattern("#H#").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerHoeRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("##H").pattern(" S ").pattern(" S ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
    }

    public static void registerIngotRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)item.get(), 9).requires((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerLeggingsRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("LLL").pattern("L#L").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), YTechRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("###").pattern("#H#").pattern("# #").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerMeshRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.TWINE) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).pattern("TTT").pattern("TTT").pattern("TTT").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.GRASS_TWINES)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).pattern("RRR").pattern("RRR").pattern("RRR").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RODS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerMortarAndPestleRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.STONE) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.PEBBLES).define(Character.valueOf('#'), Tags.Items.COBBLESTONES).pattern(" P ").pattern("# #").pattern(" # ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)Tags.Items.STONES)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('P'), YTechItemTags.PEBBLES).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern(" P ").pattern("# #").pattern(" # ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerPickaxeRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case ANTLER: {
                RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.TOOLS, (ItemLike)item.get()).requires(YTechItemTags.ANTLERS).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.SHARP_FLINTS)).save(recipeConsumer, item.getId());
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("P#R").pattern(" SH").pattern(" S ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.PICKAXE_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
            }
        }
    }

    private static void registerPlateRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)).get()).requires(ItemTags.WOODEN_SLABS).requires(YTechItemTags.AXES.tag).group(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN))).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.WOODEN_SLABS)).save(recipeConsumer, Utils.modLoc(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN)) + "_using_axe"));
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)).get(), 2).requires(ItemTags.WOODEN_SLABS).requires(YTechItemTags.SAWS.tag).group(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN))).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.WOODEN_SLABS)).save(recipeConsumer, Utils.modLoc(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN)) + "_using_saw"));
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#").pattern("#").pattern("H").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
            HammeringRecipe.Builder.hammering((TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(material)), 2, (Item)item.get()).tool(Ingredient.of(YTechItemTags.HAMMERS.tag)).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, Utils.modLoc(Utils.getPath(item) + "_from_hammering"));
        }
    }

    public static void registerRawMaterialRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.MISC, (ItemLike)item.get(), 9).requires((TagKey)YTechItemTags.RAW_STORAGE_BLOCKS.get(material)).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RAW_STORAGE_BLOCKS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    public static void registerRodRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).pattern("#").pattern("F").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
    }

    public static void registerSawRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("S##").pattern("H  ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
    }

    public static void registerSawBladeRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).pattern(" P ").pattern("PHP").pattern(" P ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
    }

    private static void registerShearsRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).pattern(" #F").pattern("RB#").pattern("LR ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
    }

    private static void registerShovelRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN)).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("S").pattern("S").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), YTechRecipeProvider.has((ItemLike)Items.STICK)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.TOOLS, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#H").pattern("S ").pattern("S ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerSpearRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.FLINT) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), (ItemLike)Items.FLINT).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" TS").pattern(" #T").pattern("#  ").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.LEATHER_STRIPS)).save(recipeConsumer, item.getId());
        } else {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" TS").pattern(" #T").pattern("#  ").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.LEATHER_STRIPS)).save(recipeConsumer, item.getId());
        }
    }

    private static void registerSwordRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.IRON) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.COMBAT, (ItemLike)item.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# ").pattern("# ").pattern("SH").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        } else {
            RemainingShapelessRecipe.Builder.shapeless(RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.SWORD_BLADE)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.PLATES.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerReinforcedBricksRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.REINFORCED_BRICKS.get()).define(Character.valueOf('B'), (ItemLike)Items.BRICKS).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.COPPER)).define(Character.valueOf('#'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.COPPER)).pattern("#P#").pattern("PBP").pattern("#P#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BRICKS), RecipeProvider.has((ItemLike)Items.BRICKS)).save(recipeConsumer, YTechBlocks.REINFORCED_BRICKS.getId());
    }

    private static void registerStrainerRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.SHARP_FLINTS, (ItemLike)YTechItems.STRAINER.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('W'), YTechItemTags.WOODEN_BOXES).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("LWL").middlePattern("LLL").topPattern("L L").topPattern("   ").topPattern("L L").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.LOGS)).save(recipeConsumer, YTechBlocks.STRAINER.getId());
    }

    private static void registerTerracottaBricksRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.TERRACOTTA_BRICKS.get(), 4).define(Character.valueOf('B'), (ItemLike)Items.TERRACOTTA).pattern("BB").pattern("BB").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.TERRACOTTA), RecipeProvider.has((ItemLike)Items.TERRACOTTA)).save(recipeConsumer, YTechBlocks.TERRACOTTA_BRICKS.getId());
    }

    private static void registerTerracottaBrickSlabRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), 6).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).pattern("BBB").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, YTechBlocks.TERRACOTTA_BRICK_SLAB.getId());
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of(YTechItemTags.TERRACOTTA_BRICKS), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_SLAB.get()), (int)2).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, Utils.modLoc(Utils.getPath(YTechBlocks.TERRACOTTA_BRICK_SLAB) + "_stonecutting"));
    }

    private static void registerTerracottaBrickStairsRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get(), 4).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, YTechBlocks.TERRACOTTA_BRICK_STAIRS.getId());
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of(YTechItemTags.TERRACOTTA_BRICKS), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get())).unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, Utils.modLoc(Utils.getPath(YTechBlocks.TERRACOTTA_BRICK_STAIRS) + "_stonecutting"));
    }

    private static void registerThatchBlockRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.THATCH.get()).define(Character.valueOf('B'), YTechItemTags.GRASS_FIBERS).pattern("BBB").pattern("BBB").pattern("BBB").unlockedBy("has_thatch", RecipeProvider.has(YTechItemTags.GRASS_FIBERS)).save(recipeConsumer, YTechBlocks.THATCH.getId());
    }

    private static void registerThatchBlockSlabRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.THATCH_SLAB.get(), 6).define(Character.valueOf('B'), YTechItemTags.THATCH).pattern("BBB").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.THATCH)).save(recipeConsumer, YTechBlocks.THATCH_SLAB.getId());
    }

    private static void registerThatchBlockStairsRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)YTechBlocks.THATCH_STAIRS.get(), 4).define(Character.valueOf('B'), YTechItemTags.THATCH).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.THATCH)).save(recipeConsumer, YTechBlocks.THATCH_STAIRS.getId());
    }

    private static void registerTreeStumpRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.AXES.tag, (ItemLike)YTechItems.TREE_STUMP.get()).define(Character.valueOf('C'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).bottomPattern("SSS").bottomPattern("SSS").bottomPattern("SSS").middlePattern("CCC").middlePattern("CCC").middlePattern("CCC").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.LOGS)).save(recipeConsumer, YTechItems.TREE_STUMP.getId());
    }

    private static void registerRawStorageBlockRecipe(RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.RAW_MATERIALS.get(material)).pattern("###").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.RAW_MATERIALS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void registerStorageBlockRecipe(RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get()).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).pattern("###").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(material)))).save(recipeConsumer, item.getId());
        }
    }

    private static void wcChestRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.CHEST).define(Character.valueOf('C'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('R'), (TagKey<Item>)((TagKey)YTechItemTags.RODS.get(MaterialType.IRON))).define(Character.valueOf('B'), (TagKey<Item>)ItemTags.WOODEN_BUTTONS).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("C C").middlePattern("CBC").topPattern("RRR").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.CHEST));
    }

    private static void wcFurnaceRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.FURNACE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).define(Character.valueOf('A'), (ItemLike)Items.CAMPFIRE).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("CAC").middlePattern("C C").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.COBBLESTONE), RecipeProvider.has((TagKey)Tags.Items.COBBLESTONES_NORMAL)).save(recipeConsumer, Utils.modLoc(Items.FURNACE));
    }

    private static void wcCraftingTableRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.SHARP_FLINTS, (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("   ").topPattern(" L ").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.CRAFTING_TABLE));
    }

    private static void wcStonecutterRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.STONECUTTER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('P'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('S'), YTechItemTags.SAW_BLADES.tag).bottomPattern("LPL").bottomPattern("PPP").bottomPattern("LPL").middlePattern("LPL").middlePattern("PPP").middlePattern("LPL").topPattern("   ").topPattern(" S ").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.SMOOTH_STONE)).save(recipeConsumer, Utils.modLoc(Items.STONECUTTER));
    }

    private static void wcBarrelRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.BARREL).define(Character.valueOf('S'), (TagKey<Item>)ItemTags.WOODEN_SLABS).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("P P").middlePattern("PPP").topPattern("SSS").topPattern("SSS").topPattern("SSS").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.BARREL));
    }

    private static void wcFletchingTableRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.FLETCHING_TABLE).define(Character.valueOf('T'), (ItemLike)Items.TARGET).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PTP").middlePattern("PPP").middlePattern("PTP").topPattern("PPP").topPattern("PPP").topPattern("PPP").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.FLETCHING_TABLE));
    }

    private static void wcCartographyTableRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.CARTOGRAPHY_TABLE).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('M'), (ItemLike)Items.MAP).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("   ").topPattern(" M ").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.CARTOGRAPHY_TABLE));
    }

    private static void wcSmithingTableRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.SMITHING_TABLE).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('C'), (TagKey<Item>)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(MaterialType.IRON))).bottomPattern("CPC").bottomPattern("PPP").bottomPattern("CPC").middlePattern("CPC").middlePattern("PPP").middlePattern("CPC").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))).save(recipeConsumer, Utils.modLoc(Items.SMITHING_TABLE));
    }

    private static void wcGrindstoneRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.GRINDSTONE).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE).bottomPattern(" L ").bottomPattern("SSS").bottomPattern(" L ").middlePattern(" L ").middlePattern("SSS").middlePattern(" L ").topPattern("   ").topPattern("SSS").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.SMOOTH_STONE)).save(recipeConsumer, Utils.modLoc(Items.GRINDSTONE));
    }

    private static void wcLoomRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.LOOM).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.STRINGS).bottomPattern("P P").bottomPattern("   ").bottomPattern("P P").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("PPP").topPattern("SSS").topPattern("SSS").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.LOOM));
    }

    private static void wcSmokerRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.SMOKER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('A'), (ItemLike)Items.CAMPFIRE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).bottomPattern("LCL").bottomPattern("CCC").bottomPattern("LCL").middlePattern("LCL").middlePattern("CAC").middlePattern("L L").topPattern("LCL").topPattern("C C").topPattern("LCL").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)Tags.Items.COBBLESTONES_NORMAL)).save(recipeConsumer, Utils.modLoc(Items.SMOKER));
    }

    private static void wcComposterRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)Items.COMPOSTER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("L L").middlePattern("LLL").topPattern("LLL").topPattern("L L").topPattern("LLL").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(Items.COMPOSTER));
    }

    private static void wcWoodenBoxRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.WOODEN_BOX.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("L L").middlePattern("LLL").topPattern("   ").topPattern("   ").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(YTechItems.WOODEN_BOX));
    }

    private static void wcToolRackRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.TOOL_RACK.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), YTechItemTags.BOLTS.tag).bottomPattern("LLL").bottomPattern("BBB").bottomPattern("   ").middlePattern("LLL").middlePattern("BBB").middlePattern("   ").topPattern("LLL").topPattern("BBB").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeConsumer, Utils.modLoc(YTechItems.TOOL_RACK));
    }

    private static void wcWellPulleyRecipe(RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.WELL_PULLEY.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('V'), YTechItemTags.AQUEDUCT_VALVES).bottomPattern("BBB").bottomPattern("BVB").bottomPattern("BBB").middlePattern("   ").middlePattern("LTL").middlePattern("   ").topPattern("   ").topPattern("LPL").topPattern("   ").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, Utils.modLoc(YTechItems.WELL_PULLEY));
    }
}

