/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class YTechArmorMaterials {
    private static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)"ytech");
    public static final MaterialArmor ARMORS = new MaterialArmor(EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.COPPER, MaterialType.BRONZE));

    public static void register(IEventBus eventBus) {
        ARMOR_MATERIALS.register(eventBus);
    }

    public static class MaterialArmor {
        protected final Map<MaterialType, DeferredHolder<ArmorMaterial, ArmorMaterial>> armors = new HashMap<MaterialType, DeferredHolder<ArmorMaterial, ArmorMaterial>>();
        protected final Map<MaterialType, Integer> durability = new HashMap<MaterialType, Integer>();

        MaterialArmor(EnumSet<MaterialType> materialTypes) {
            materialTypes.forEach(material -> {
                String key = material.key + "_armor";
                block0 : switch (material) {
                    case IRON: {
                        this.armors.put((MaterialType)material, (DeferredHolder<ArmorMaterial, ArmorMaterial>)DeferredHolder.create((ResourceKey)((ResourceKey)ArmorMaterials.IRON.unwrap().orThrow())));
                        this.durability.put((MaterialType)material, 15);
                        break;
                    }
                    case GOLD: {
                        this.armors.put((MaterialType)material, (DeferredHolder<ArmorMaterial, ArmorMaterial>)DeferredHolder.create((ResourceKey)((ResourceKey)ArmorMaterials.GOLD.unwrap().orThrow())));
                        this.durability.put((MaterialType)material, 7);
                        break;
                    }
                    default: {
                        this.armors.put((MaterialType)material, (DeferredHolder<ArmorMaterial, ArmorMaterial>)ARMOR_MATERIALS.register(key, () -> new ArmorMaterial(Map.of(ArmorItem.Type.BODY, 1, ArmorItem.Type.BOOTS, 2, ArmorItem.Type.CHESTPLATE, 3, ArmorItem.Type.HELMET, 3, ArmorItem.Type.LEGGINGS, 3), material.getTier().getEnchantmentValue(), SoundEvents.ARMOR_EQUIP_IRON, () -> material.getTier().getRepairIngredient(), List.of(new ArmorMaterial.Layer(Utils.modLoc(material.key))), 0.0f, 0.0f)));
                        switch (material) {
                            case COPPER: {
                                this.durability.put((MaterialType)material, 7);
                                break block0;
                            }
                            case BRONZE: {
                                this.durability.put((MaterialType)material, 10);
                            }
                        }
                    }
                }
            });
        }

        public DeferredHolder<ArmorMaterial, ArmorMaterial> get(MaterialType material) {
            return Objects.requireNonNull(this.armors.get(material), material.key);
        }

        public int getDurability(MaterialType material) {
            return Objects.requireNonNull(this.durability.get(material), material.key);
        }
    }
}

