/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.NameHolder;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AmphoraBlock;
import com.yanny.ytech.configuration.block.AqueductBlock;
import com.yanny.ytech.configuration.block.AqueductFertilizerBlock;
import com.yanny.ytech.configuration.block.AqueductHydratorBlock;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block.BrickChimneyBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.PrimitiveAlloySmelterBlock;
import com.yanny.ytech.configuration.block.PrimitiveSmelterBlock;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block.StrainerBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.block.ToolRackBlock;
import com.yanny.ytech.configuration.block.TreeStumpBlock;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class YTechBlocks {
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ytech");
    public static final DeferredBlock<Block> AMPHORA = BLOCKS.register("amphora", AmphoraBlock::new);
    public static final DeferredBlock<Block> AQUEDUCT_FERTILIZER = BLOCKS.register("aqueduct_fertilizer", AqueductFertilizerBlock::new);
    public static final DeferredBlock<Block> AQUEDUCT_HYDRATOR = BLOCKS.register("aqueduct_hydrator", AqueductHydratorBlock::new);
    public static final DeferredBlock<Block> AQUEDUCT_VALVE = BLOCKS.register("aqueduct_valve", AqueductValveBlock::new);
    public static final DeferredBlock<Block> BRICK_CHIMNEY = BLOCKS.register("brick_chimney", BrickChimneyBlock::new);
    public static final DeferredBlock<Block> BRONZE_ANVIL = BLOCKS.register("bronze_anvil", BronzeAnvilBlock::new);
    public static final DeferredBlock<Block> CRAFTING_WORKSPACE = BLOCKS.register("crafting_workspace", CraftingWorkspaceBlock::new);
    public static final DeferredBlock<Block> FIRE_PIT = BLOCKS.register("fire_pit", FirePitBlock::new);
    public static final DeferredBlock<Block> GRASS_BED = BLOCKS.register("grass_bed", GrassBedBlock::new);
    public static final DeferredBlock<Block> MILLSTONE = BLOCKS.register("millstone", MillstoneBlock::new);
    public static final DeferredBlock<Block> POTTERS_WHEEL = BLOCKS.register("potters_wheel", PottersWheelBlock::new);
    public static final DeferredBlock<Block> PRIMITIVE_ALLOY_SMELTER = BLOCKS.register("primitive_alloy_smelter", PrimitiveAlloySmelterBlock::new);
    public static final DeferredBlock<Block> PRIMITIVE_SMELTER = BLOCKS.register("primitive_smelter", PrimitiveSmelterBlock::new);
    public static final DeferredBlock<Block> REINFORCED_BRICKS = YTechBlocks.registerBlock("reinforced_bricks", (BlockBehaviour)Blocks.BRICKS);
    public static final DeferredBlock<Block> REINFORCED_BRICK_CHIMNEY = BLOCKS.register("reinforced_brick_chimney", ReinforcedBrickChimneyBlock::new);
    public static final DeferredBlock<Block> STRAINER = BLOCKS.register("strainer", StrainerBlock::new);
    public static final DeferredBlock<Block> TERRACOTTA_BRICKS = YTechBlocks.registerBlock("terracotta_bricks", (BlockBehaviour)Blocks.BRICKS);
    public static final DeferredBlock<Block> TERRACOTTA_BRICK_SLAB = YTechBlocks.registerSlab("terracotta_brick_slab", (BlockBehaviour)Blocks.BRICK_SLAB);
    public static final DeferredBlock<Block> TERRACOTTA_BRICK_STAIRS = YTechBlocks.registerStairs("terracotta_brick_stairs", TERRACOTTA_BRICKS, (BlockBehaviour)Blocks.BRICK_STAIRS);
    public static final DeferredBlock<Block> THATCH = YTechBlocks.registerBlock("thatch", (BlockBehaviour)Blocks.HAY_BLOCK);
    public static final DeferredBlock<Block> THATCH_SLAB = YTechBlocks.registerSlab("thatch_slab", (BlockBehaviour)Blocks.HAY_BLOCK);
    public static final DeferredBlock<Block> THATCH_STAIRS = YTechBlocks.registerStairs("thatch_stairs", THATCH, (BlockBehaviour)Blocks.HAY_BLOCK);
    public static final DeferredBlock<Block> TOOL_RACK = BLOCKS.register("tool_rack", ToolRackBlock::new);
    public static final DeferredBlock<Block> TREE_STUMP = BLOCKS.register("tree_stump", TreeStumpBlock::new);
    public static final DeferredBlock<Block> WELL_PULLEY = BLOCKS.register("well_pulley", WellPulleyBlock::new);
    public static final DeferredBlock<Block> WOODEN_BOX = BLOCKS.register("wooden_box", WoodenBoxBlock::new);
    public static final MaterialBlock AQUEDUCTS = new MaterialBlock("aqueduct", NameHolder.suffix("aqueduct"), MaterialType.AQUEDUCT_MATERIALS, AqueductBlock::new);
    public static final MaterialBlock DEEPSLATE_ORES = new DeepslateOreMaterialBlock();
    public static final MaterialBlock DRYING_RACKS = new MaterialBlock("drying_rack", NameHolder.suffix("drying_rack"), MaterialType.ALL_WOODS, DryingRackBlock::new);
    public static final MaterialBlock GRAVEL_DEPOSITS = new MaterialBlock("gravel_deposit", NameHolder.suffix("gravel_deposit"), MaterialType.ALL_DEPOSIT_ORES, () -> new ColoredFallingBlock(new ColorRGBA(-8356741), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL)));
    public static final MaterialBlock NETHER_ORES = new NetherOreMaterialBlock();
    public static final MaterialBlock RAW_STORAGE_BLOCKS = new RawStorageBlockMaterialBlock();
    public static final MaterialBlock SAND_DEPOSITS = new MaterialBlock("sand_deposit", NameHolder.suffix("sand_deposit"), MaterialType.ALL_DEPOSIT_ORES, () -> new ColoredFallingBlock(new ColorRGBA(14406560), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
    public static final MaterialBlock STONE_ORES = new StoneOreMaterialBlock();
    public static final MaterialBlock STORAGE_BLOCKS = new StorageBlockMaterialBlock();
    public static final MaterialBlock TANNING_RACKS = new MaterialBlock("tanning_rack", NameHolder.suffix("tanning_rack"), MaterialType.ALL_WOODS, TanningRackBlock::new);

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static DeferredBlock<Block> registerBlock(String name, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)behaviour)));
    }

    private static DeferredBlock<Block> registerSlab(String name, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)behaviour)));
    }

    private static DeferredBlock<Block> registerStairs(String name, DeferredBlock<Block> baseBlock, BlockBehaviour behaviour) {
        return BLOCKS.register(name, () -> new StairBlock(((Block)baseBlock.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)behaviour)));
    }

    public static class MaterialBlock {
        protected final String group;
        protected final NameHolder nameHolder;
        protected final Map<MaterialType, DeferredBlock<Block>> blocks;

        public MaterialBlock(String group, NameHolder nameHolder, EnumSet<MaterialType> materialTypes, Function<MaterialType, Block> itemSupplier) {
            this.group = group;
            this.nameHolder = nameHolder;
            this.blocks = new HashMap<MaterialType, DeferredBlock<Block>>();
            materialTypes.forEach(type -> {
                Object key = nameHolder.prefix() != null ? nameHolder.prefix() + "_" : "";
                key = type.key.equals("gold") && nameHolder.prefix() == null ? (String)key + "golden" : (String)key + type.key;
                key = (String)key + (String)(nameHolder.suffix() != null ? "_" + nameHolder.suffix() : "");
                this.blocks.put((MaterialType)type, (DeferredBlock<Block>)BLOCKS.register((String)key, () -> (Block)itemSupplier.apply((MaterialType)type)));
            });
        }

        public MaterialBlock(String group, NameHolder nameHolder, EnumSet<MaterialType> materialTypes, Supplier<Block> itemSupplier) {
            this(group, nameHolder, materialTypes, (MaterialType m) -> (Block)itemSupplier.get());
        }

        public DeferredBlock<Block> of(MaterialType material) {
            return Objects.requireNonNull(this.blocks.get(material));
        }

        public Collection<DeferredBlock<Block>> blocks() {
            return this.blocks.values();
        }

        public Set<MaterialType> materials() {
            return this.blocks.keySet();
        }

        public Set<Map.Entry<MaterialType, DeferredBlock<Block>>> entries() {
            return this.blocks.entrySet();
        }

        public String getGroup() {
            return this.group;
        }
    }

    private static class DeepslateOreMaterialBlock
    extends MaterialBlock {
        public DeepslateOreMaterialBlock() {
            super("deepslate_ore", NameHolder.both("deepslate", "ore"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE)));
            this.blocks.put(MaterialType.COPPER, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_COPPER_ORE)));
            this.blocks.put(MaterialType.GOLD, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_GOLD_ORE)));
            this.blocks.put(MaterialType.IRON, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_IRON_ORE)));
        }
    }

    private static class NetherOreMaterialBlock
    extends MaterialBlock {
        public NetherOreMaterialBlock() {
            super("nether_ore", NameHolder.both("nether", "ore"), (EnumSet<MaterialType>)Utils.exclude(MaterialType.ALL_ORES, (Enum[])new MaterialType[]{MaterialType.GOLD}), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_GOLD_ORE)));
            this.blocks.put(MaterialType.GOLD, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_GOLD_ORE)));
        }
    }

    private static class RawStorageBlockMaterialBlock
    extends MaterialBlock {
        public RawStorageBlockMaterialBlock() {
            super("storage_block", NameHolder.both("raw", "block"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK)));
            this.blocks.put(MaterialType.COPPER, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.RAW_COPPER_BLOCK)));
            this.blocks.put(MaterialType.GOLD, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.RAW_GOLD_BLOCK)));
            this.blocks.put(MaterialType.IRON, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.RAW_IRON_BLOCK)));
        }
    }

    private static class StoneOreMaterialBlock
    extends MaterialBlock {
        public StoneOreMaterialBlock() {
            super("stone_ore", NameHolder.suffix("ore"), Utils.exclude(MaterialType.ALL_ORES, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE)));
            this.blocks.put(MaterialType.COPPER, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.COPPER_ORE)));
            this.blocks.put(MaterialType.GOLD, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.GOLD_ORE)));
            this.blocks.put(MaterialType.IRON, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.IRON_ORE)));
        }
    }

    private static class StorageBlockMaterialBlock
    extends MaterialBlock {
        public StorageBlockMaterialBlock() {
            super("storage_block", NameHolder.suffix("block"), Utils.exclude(MaterialType.ALL_METALS, MaterialType.VANILLA_METALS), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
            this.blocks.put(MaterialType.COPPER, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.COPPER_BLOCK)));
            this.blocks.put(MaterialType.GOLD, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.GOLD_BLOCK)));
            this.blocks.put(MaterialType.IRON, DeferredBlock.createBlock((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)Blocks.IRON_BLOCK)));
        }
    }
}

