/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.compatibility.jei.AlloyingRecipeCategory;
import com.yanny.ytech.compatibility.jei.BlockHitRecipeCategory;
import com.yanny.ytech.compatibility.jei.ChoppingRecipeCategory;
import com.yanny.ytech.compatibility.jei.DryingRecipeCategory;
import com.yanny.ytech.compatibility.jei.HammeringRecipeCategory;
import com.yanny.ytech.compatibility.jei.MillingRecipeCategory;
import com.yanny.ytech.compatibility.jei.PotteryRecipeCategory;
import com.yanny.ytech.compatibility.jei.SmeltingRecipeCategory;
import com.yanny.ytech.compatibility.jei.TanningRecipeCategory;
import com.yanny.ytech.compatibility.jei.WorkspaceCraftingCategory;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    protected static final Logger LOGGER = LogUtils.getLogger();

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TanningRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MillingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockHitRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlloyingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammeringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PotteryRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkspaceCraftingCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChoppingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            registration.addRecipes(DryingRecipeCategory.RECIPE_TYPE, DryingRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(TanningRecipeCategory.RECIPE_TYPE, TanningRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(MillingRecipeCategory.RECIPE_TYPE, MillingRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(SmeltingRecipeCategory.RECIPE_TYPE, SmeltingRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(BlockHitRecipeCategory.RECIPE_TYPE, BlockHitRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(AlloyingRecipeCategory.RECIPE_TYPE, AlloyingRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(HammeringRecipeCategory.RECIPE_TYPE, HammeringRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(PotteryRecipeCategory.RECIPE_TYPE, PotteryRecipeCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(WorkspaceCraftingCategory.RECIPE_TYPE, WorkspaceCraftingCategory.getRecipes(level.m_7465_()));
            registration.addRecipes(ChoppingRecipeCategory.RECIPE_TYPE, ChoppingRecipeCategory.getRecipes(level.m_7465_()));
            registration.addItemStackInfo(((Item)YTechItems.GRASS_FIBERS.get()).m_7968_(), new Component[]{Component.m_237115_((String)"text.ytech.info.grass_fibers")});
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        DryingRecipeCategory.registerCatalyst(registration);
        TanningRecipeCategory.registerCatalyst(registration);
        MillingRecipeCategory.registerCatalyst(registration);
        SmeltingRecipeCategory.registerCatalyst(registration);
        AlloyingRecipeCategory.registerCatalyst(registration);
        HammeringRecipeCategory.registerCatalyst(registration);
        PotteryRecipeCategory.registerCatalyst(registration);
        WorkspaceCraftingCategory.registerCatalyst(registration);
        ChoppingRecipeCategory.registerCatalyst(registration);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }
}

