/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.MapRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapedRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema;
import dev.latvian.mods.kubejs.util.TinyMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class KubeJsCompatibility
extends KubeJSPlugin {
    static RecipeComponent<InputItem> YTECH_INPUT = new RecipeComponent<InputItem>(){

        public Class<?> componentClass() {
            return InputItem.class;
        }

        public JsonElement write(RecipeJS recipeJS, InputItem inputItem) {
            JsonObject result = new JsonObject();
            result.add("ingredient", inputItem.ingredient.m_43942_());
            result.addProperty("count", (Number)inputItem.count);
            return result;
        }

        public InputItem read(RecipeJS recipeJS, Object o) {
            JsonObject json;
            if (o instanceof JsonObject && (json = (JsonObject)o).has("ingredient")) {
                return InputItem.of((Ingredient)IngredientJS.of((Object)json.get("ingredient")), (int)json.get("count").getAsInt());
            }
            return InputItem.of((Object)o);
        }
    };

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.ALLOYING), AlloyingJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.BLOCK_HIT), BlockHitJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.CHOPPING), ChoppingJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.DRYING), DryingJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.HAMMERING), HammeringJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.MILLING), MillingJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.POTTERY), PotteryJS.SCHEMA);
        event.register(Utils.modLoc("remaining_part_shapeless_crafting"), ShapelessRecipeSchema.SCHEMA);
        event.register(Utils.modLoc("remaining_shaped_crafting"), ShapedRecipeSchema.SCHEMA);
        event.register(Utils.modLoc("remaining_shapeless_crafting"), ShapelessRecipeSchema.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.SMELTING), SmeltingJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.TANNING), TanningJS.SCHEMA);
        event.register(KubeJsCompatibility.ref(YTechRecipeTypes.WORKSPACE_CRAFTING), WorkspaceCraftingJS.SCHEMA);
    }

    private static <T extends Recipe<?>> ResourceLocation ref(RegistryObject<RecipeType<T>> recipeType) {
        return new ResourceLocation(((RecipeType)recipeType.get()).toString());
    }

    private static class AlloyingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT1 = YTECH_INPUT.key("ingredient1");
        private static final RecipeKey<InputItem> INGREDIENT2 = YTECH_INPUT.key("ingredient2");
        private static final RecipeKey<Integer> MIN_TEMPERATURE = NumberComponent.INT.key("minTemp").optional((Object)1000).exclude().alwaysWrite();
        private static final RecipeKey<Integer> SMELTING_TIME = NumberComponent.INT.key("smeltingTime").optional((Object)200).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(AlloyingJS.class, AlloyingJS::new, new RecipeKey[]{RESULT, INGREDIENT1, INGREDIENT2, MIN_TEMPERATURE, SMELTING_TIME});

        private AlloyingJS() {
        }
    }

    private static class BlockHitJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<InputItem> BLOCK = ItemComponents.INPUT.key("block");
        private static final RecipeSchema SCHEMA = new RecipeSchema(BlockHitJS.class, BlockHitJS::new, new RecipeKey[]{RESULT, INGREDIENT, BLOCK});

        private BlockHitJS() {
        }
    }

    private static class ChoppingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<InputItem> TOOL = ItemComponents.INPUT.key("tool");
        private static final RecipeKey<Integer> HIT_COUNT = NumberComponent.INT.key("hitCount").optional((Object)3).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(ChoppingJS.class, ChoppingJS::new, new RecipeKey[]{RESULT, INGREDIENT, TOOL, HIT_COUNT});

        private ChoppingJS() {
        }
    }

    private static class DryingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<Integer> DRYING_TIME = NumberComponent.INT.key("dryingTime").optional((Object)1200).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(DryingJS.class, DryingJS::new, new RecipeKey[]{RESULT, INGREDIENT, DRYING_TIME});

        private DryingJS() {
        }
    }

    private static class HammeringJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<InputItem> TOOL = ItemComponents.INPUT.key("tool").allowEmpty().optional((Object)InputItem.EMPTY).exclude().alwaysWrite();
        private static final RecipeKey<Integer> HIT_COUNT = NumberComponent.INT.key("hitCount").optional((Object)2).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(HammeringJS.class, HammeringJS::new, new RecipeKey[]{RESULT, INGREDIENT, HIT_COUNT, TOOL});

        private HammeringJS() {
        }
    }

    private static class MillingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<Float> BONUS_CHANCE = NumberComponent.FLOAT.key("bonusChance").optional((Object)Float.valueOf(0.5f)).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(MillingJS.class, MillingJS::new, new RecipeKey[]{RESULT, INGREDIENT, BONUS_CHANCE});

        private MillingJS() {
        }
    }

    private static class PotteryJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<Integer> COUNT = NumberComponent.INT.key("count");
        private static final RecipeSchema SCHEMA = new RecipeSchema(PotteryJS.class, PotteryJS::new, new RecipeKey[]{RESULT, COUNT});

        private PotteryJS() {
        }
    }

    private static class SmeltingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<Integer> INPUT_COUNT = NumberComponent.INT.key("inputCount").optional((Object)1).exclude().alwaysWrite();
        private static final RecipeKey<InputItem> MOLD = ItemComponents.INPUT.key("mold").allowEmpty().optional((Object)InputItem.EMPTY).exclude().alwaysWrite();
        private static final RecipeKey<Integer> MIN_TEMP = NumberComponent.INT.key("minTemp").optional((Object)1000).exclude().alwaysWrite();
        private static final RecipeKey<Integer> SMELTING_TIME = NumberComponent.INT.key("smeltingTime").optional((Object)200).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(SmeltingJS.class, SmeltingJS::new, new RecipeKey[]{RESULT, INGREDIENT, INPUT_COUNT, MOLD, MIN_TEMP, SMELTING_TIME});

        private SmeltingJS() {
        }
    }

    private static class TanningJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient");
        private static final RecipeKey<InputItem> TOOL = ItemComponents.INPUT.key("tool").allowEmpty().optional((Object)InputItem.EMPTY).exclude().alwaysWrite();
        private static final RecipeKey<Integer> HIT_COUNT = NumberComponent.INT.key("hitCount").optional((Object)5).exclude().alwaysWrite();
        private static final RecipeSchema SCHEMA = new RecipeSchema(TanningJS.class, TanningJS::new, new RecipeKey[]{RESULT, INGREDIENT, TOOL, HIT_COUNT});

        private TanningJS() {
        }
    }

    private static class WorkspaceCraftingJS
    extends RecipeJS {
        private static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
        private static final RecipeKey<String[]> BOTTOM_PATTERN = StringComponent.NON_EMPTY.asArray().key("bottom");
        private static final RecipeKey<String[]> MIDDLE_PATTERN = StringComponent.NON_EMPTY.asArray().key("middle");
        private static final RecipeKey<String[]> TOP_PATTERN = StringComponent.NON_EMPTY.asArray().key("top");
        private static final RecipeKey<TinyMap<String, String[]>> PATTERN = new MapRecipeComponent(StringComponent.NON_EMPTY, (RecipeComponent)StringComponent.NON_EMPTY.asArray(), true).key("pattern");
        private static final RecipeKey<TinyMap<Character, InputItem>> KEY = MapRecipeComponent.ITEM_PATTERN_KEY.key("key");
        private static final RecipeKey<InputItem> TOOL = ItemComponents.INPUT.key("tool");
        private static final RecipeSchema SCHEMA = new RecipeSchema(WorkspaceCraftingJS.class, WorkspaceCraftingJS::new, new RecipeKey[]{RESULT, TOOL, PATTERN, KEY}).constructor(new RecipeKey[]{RESULT, TOOL, PATTERN, KEY}).constructor((recipe, schema, keys, map) -> ((WorkspaceCraftingJS)recipe).mergeParams(map), new RecipeKey[]{RESULT, TOOL, BOTTOM_PATTERN, MIDDLE_PATTERN, TOP_PATTERN, KEY});

        private WorkspaceCraftingJS() {
        }

        private void mergeParams(ComponentValueMap from) {
            this.setValue(RESULT, (OutputItem)from.getValue((RecipeJS)this, RESULT));
            this.setValue(TOOL, (InputItem)from.getValue((RecipeJS)this, TOOL));
            this.setValue(KEY, (TinyMap)from.getValue((RecipeJS)this, KEY));
            String[] bottom = (String[])from.getValue((RecipeJS)this, BOTTOM_PATTERN);
            String[] middle = (String[])from.getValue((RecipeJS)this, MIDDLE_PATTERN);
            String[] top = (String[])from.getValue((RecipeJS)this, TOP_PATTERN);
            Map<String, String[]> pattern = Map.of("bottom", bottom, "middle", middle, "top", top);
            this.setValue(PATTERN, TinyMap.ofMap(pattern));
        }

        public void afterLoaded() {
            super.afterLoaded();
            Map<String, String[]> pattern = Arrays.stream(((TinyMap)this.getValue(PATTERN)).entries()).collect(Collectors.toMap(TinyMap.Entry::key, TinyMap.Entry::value));
            if (!pattern.containsKey("bottom")) {
                throw new RecipeExceptionJS("Pattern is missing bottom part!");
            }
            if (!pattern.containsKey("middle")) {
                throw new RecipeExceptionJS("Pattern is missing middle part!");
            }
            if (!pattern.containsKey("top")) {
                throw new RecipeExceptionJS("Pattern is missing top part!");
            }
            if (pattern.get("bottom").length != 3) {
                throw new RecipeExceptionJS("Bottom pattern must have 3 rows");
            }
            if (pattern.get("middle").length != 3) {
                throw new RecipeExceptionJS("Middle pattern must have 3 rows");
            }
            if (pattern.get("top").length != 3) {
                throw new RecipeExceptionJS("Top pattern must have 3 rows");
            }
            for (String bottom : pattern.get("bottom")) {
                if (bottom.length() == 3) continue;
                throw new RecipeExceptionJS("Bottom pattern length must be 3!");
            }
            for (String middle : pattern.get("middle")) {
                if (middle.length() == 3) continue;
                throw new RecipeExceptionJS("Middle pattern length must be 3!");
            }
            for (String top : pattern.get("top")) {
                if (top.length() == 3) continue;
                throw new RecipeExceptionJS("Top pattern length must be 3!");
            }
        }
    }
}

