/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class MillingRecipeCategory
extends AbstractRecipeCategory<MillingRecipe> {
    public static final RecipeType<MillingRecipe> RECIPE_TYPE = RecipeType.create((String)"ytech", (String)"milling", MillingRecipe.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));

    public MillingRecipeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.m_237115_((String)"emi.category.ytech.milling"), guiHelper.createDrawableItemLike((ItemLike)YTechItems.MILLSTONE.get()), 84, 37);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MillingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 5).setStandardSlotBackground().addIngredients(recipe.ingredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 5).setOutputSlotBackground().addItemStack(recipe.result());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, @NotNull MillingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(26, 5);
    }

    public void draw(MillingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MutableComponent chance = Component.m_237110_((String)"emi.milling.chance", (Object[])new Object[]{DECIMAL_FORMAT.format(recipe.bonusChance() * 100.0f)});
        int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)chance);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)chance, 42 - width / 2, 29, 0, false);
    }

    public static List<MillingRecipe> getRecipes(@NotNull RecipeManager recipeManager) {
        return recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)YTechRecipeTypes.MILLING.get()).stream().toList();
    }

    public static void registerCatalyst(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.MILLSTONE.get()), new RecipeType[]{RECIPE_TYPE});
    }
}

