/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static ResourceLocation mcLoc(@NotNull String path) {
        return new ResourceLocation(path);
    }

    @NotNull
    public static ResourceLocation mcBlockLoc(@NotNull String path) {
        return Utils.mcLoc("block/" + path);
    }

    @NotNull
    public static ResourceLocation mcItemLoc(@NotNull String path) {
        return Utils.mcLoc("item/" + path);
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull String path) {
        return new ResourceLocation("ytech", path);
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull Item item) {
        return Utils.modLoc(Utils.loc(item).m_135815_());
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull RegistryObject<?> object) {
        return Utils.modLoc(object.getId().m_135815_());
    }

    @NotNull
    public static ResourceLocation modBlockLoc(@NotNull String path) {
        return Utils.modLoc("block/" + path);
    }

    @NotNull
    public static ResourceLocation modItemLoc(@NotNull String path) {
        return Utils.modLoc("item/" + path);
    }

    @NotNull
    public static ResourceLocation loc(@NotNull Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    @NotNull
    public static ResourceLocation loc(@NotNull Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    @NotNull
    public static ResourceLocation blockLoc(@NotNull Block block) {
        ResourceLocation loc = Utils.loc(block);
        return new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_());
    }

    public static String getPath(RegistryObject<?> object) {
        return object.getId().m_135815_();
    }

    @NotNull
    public static String getHasItem(TagKey<Item> item) {
        return "has_" + item.f_203868_().m_135815_();
    }

    public static String getHasItem(RegistryObject<?> item) {
        return "has_" + Utils.getPath(item);
    }

    @NotNull
    public static String getHasName() {
        return "has_item";
    }

    @NotNull
    public static TagKey<Item> getLogFromMaterial(MaterialType material) {
        return switch (material) {
            case MaterialType.ACACIA_WOOD -> ItemTags.f_13186_;
            case MaterialType.BIRCH_WOOD -> ItemTags.f_13185_;
            case MaterialType.CHERRY_WOOD -> ItemTags.f_271202_;
            case MaterialType.DARK_OAK_WOOD -> ItemTags.f_13183_;
            case MaterialType.JUNGLE_WOOD -> ItemTags.f_13187_;
            case MaterialType.MANGROVE_WOOD -> ItemTags.f_215869_;
            case MaterialType.OAK_WOOD -> ItemTags.f_13184_;
            case MaterialType.SPRUCE_WOOD -> ItemTags.f_13188_;
            default -> throw new IllegalStateException("Not wood type provided!");
        };
    }

    @NotNull
    public static CompoundTag saveBlockPos(@NotNull BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        return tag;
    }

    @NotNull
    public static BlockPos loadBlockPos(@NotNull CompoundTag tag) {
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> merge(@NotNull EnumSet<E> first, E ... list) {
        Object copy = first.clone();
        ((AbstractCollection)copy).addAll(Arrays.asList(list));
        return copy;
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> exclude(@NotNull EnumSet<E> enumSet, E ... list) {
        Object copy = enumSet.clone();
        for (E e : list) {
            ((AbstractCollection)copy).remove(e);
        }
        return copy;
    }

    @NotNull
    public static <E extends Enum<E>> EnumSet<E> exclude(@NotNull EnumSet<E> enumSet, @NotNull EnumSet<E> toRemove) {
        Object copy = enumSet.clone();
        ((AbstractSet)copy).removeAll(toRemove);
        return copy;
    }
}

