/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public enum YTechArmorMaterial {
    IRON(MaterialType.IRON, (ArmorMaterial)ArmorMaterials.IRON),
    GOLD(MaterialType.GOLD, (ArmorMaterial)ArmorMaterials.GOLD),
    COPPER(MaterialType.COPPER, 7, YTechArmorMaterial.getHealthFunctionForType(1, 2, 4, 1), 10, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)))),
    BRONZE(MaterialType.BRONZE, 10, YTechArmorMaterial.getHealthFunctionForType(2, 3, 5, 2), 19, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))));

    private static final Map<MaterialType, ArmorMaterial> ARMORS;
    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final MaterialType material;
    private final ArmorMaterial armorMaterial;

    private YTechArmorMaterial(MaterialType material, ArmorMaterial armorMaterial) {
        this.material = material;
        this.armorMaterial = armorMaterial;
    }

    private YTechArmorMaterial(final MaterialType material, final int durabilityMultiplier, final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, final int enchantmentValue, final SoundEvent sound, final float toughness, final float knockbackResistance, final Supplier<Ingredient> repairIngredient) {
        this.material = material;
        this.armorMaterial = new ArmorMaterial(){

            public int m_266425_(@NotNull ArmorItem.Type pType) {
                return HEALTH_FUNCTION_FOR_TYPE.get(pType) * durabilityMultiplier;
            }

            public int m_7366_(@NotNull ArmorItem.Type pType) {
                return (Integer)protectionFunctionForType.get(pType);
            }

            public int m_6646_() {
                return enchantmentValue;
            }

            @NotNull
            public SoundEvent m_7344_() {
                return sound;
            }

            @NotNull
            public Ingredient m_6230_() {
                return (Ingredient)repairIngredient.get();
            }

            @NotNull
            public String m_6082_() {
                return Utils.modLoc(material.key).toString();
            }

            public float m_6651_() {
                return toughness;
            }

            public float m_6649_() {
                return knockbackResistance;
            }
        };
    }

    private static EnumMap<ArmorItem.Type, Integer> getHealthFunctionForType(int boots, int leggings, int chestplate, int helmet) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, boots);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    public static ArmorMaterial get(MaterialType materialType) {
        return ARMORS.get(materialType);
    }

    static {
        ARMORS = new HashMap<MaterialType, ArmorMaterial>();
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), type -> {
            type.put(ArmorItem.Type.BOOTS, 13);
            type.put(ArmorItem.Type.LEGGINGS, 15);
            type.put(ArmorItem.Type.CHESTPLATE, 16);
            type.put(ArmorItem.Type.HELMET, 11);
        });
        for (YTechArmorMaterial value : YTechArmorMaterial.values()) {
            ARMORS.put(value.material, value.armorMaterial);
        }
    }
}

