/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class YTechConfigSpec {
    private final ForgeConfigSpec.BooleanValue noDryingDuringRain;
    private final ForgeConfigSpec.BooleanValue finiteWaterSource;
    private final ForgeConfigSpec.BooleanValue cropsNeedWateredFarmland;
    private final ForgeConfigSpec.BooleanValue farmlandConsumesWater;
    private final ForgeConfigSpec.IntValue baseFluidStoragePerBlock;
    private final ForgeConfigSpec.BooleanValue rainingFillAqueduct;
    private final ForgeConfigSpec.IntValue rainingFillAmount;
    private final ForgeConfigSpec.IntValue rainingFillPerNthTick;
    private final ForgeConfigSpec.BooleanValue validBlockForRaining;
    private final ForgeConfigSpec.BooleanValue drippingFillAqueduct;
    private final ForgeConfigSpec.IntValue drippingFillAmount;
    private final ForgeConfigSpec.IntValue drippingFillPerNthTick;
    private final ForgeConfigSpec.IntValue valveFillAmount;
    private final ForgeConfigSpec.IntValue valveFillPerNthTick;
    private final ForgeConfigSpec.IntValue valveChanceToDrainWater;
    private final ForgeConfigSpec.IntValue hydratorDrainAmount;
    private final ForgeConfigSpec.IntValue hydratorDrainPerNthTick;
    private final ForgeConfigSpec.IntValue fertilizerDuration;
    private final ForgeConfigSpec.IntValue applyFertilizerChance;
    private final ForgeConfigSpec.IntValue wellPulleyGeneration;
    private final ForgeConfigSpec.DoubleValue wetBiomeBonus;
    private final ForgeConfigSpec.DoubleValue dryBiomeBonus;
    private final ForgeConfigSpec.DoubleValue foodExhaustionOnUse;
    private final ForgeConfigSpec.IntValue minBreedingGenerations;
    private final ForgeConfigSpec.DoubleValue domesticChance;
    private final ForgeConfigSpec.BooleanValue removeVanillaMobs;
    private final ForgeConfigSpec.IntValue minSmelterTemperature;
    private final ForgeConfigSpec.IntValue maxSmelterTemperature;
    private final ForgeConfigSpec.IntValue temperaturePerChimney;

    public YTechConfigSpec(@NotNull ForgeConfigSpec.Builder builder) {
        builder.push("waterBehavior");
        this.finiteWaterSource = builder.comment("If water sources are finite").worldRestart().define("finiteWaterSource", true);
        this.cropsNeedWateredFarmland = builder.comment("If crops need watered farmland for growing").worldRestart().define("cropsNeedWateredFarmland", true);
        this.farmlandConsumesWater = builder.comment("If hydrating farmland causes removing water source").worldRestart().define("farmlandConsumesWater", true);
        builder.pop();
        builder.push("dryingRack");
        this.noDryingDuringRain = builder.comment("If Drying Rack should stop working during rain").worldRestart().define("noDryingDuringRain", true);
        builder.pop();
        builder.push("irrigation");
        builder.push("aqueduct");
        this.baseFluidStoragePerBlock = builder.comment("Base amount of fluid stored per block").worldRestart().defineInRange("baseFluidStoragePerBlock", 500, 1, Integer.MAX_VALUE);
        this.rainingFillAqueduct = builder.comment("If raining should fill aqueduct").worldRestart().define("rainingFillAqueduct", true);
        this.rainingFillAmount = builder.comment("Amount of which will be aqueduct filled per nth tick when raining").worldRestart().defineInRange("rainingFillAmount", 1, 1, Integer.MAX_VALUE);
        this.rainingFillPerNthTick = builder.comment("How often should be filled aqueduct when raining (1 - every tick, 20 - every second)").worldRestart().defineInRange("rainingFillPerNthTick", 10, 1, Integer.MAX_VALUE);
        this.validBlockForRaining = builder.comment("If aqueduct must see sky and must be in valid biome where is raining when raining for filling").worldRestart().define("validBlockForRaining", true);
        this.drippingFillAqueduct = builder.comment("If dripping should fill aqueduct").worldRestart().define("drippingFillAqueduct", true);
        this.drippingFillAmount = builder.comment("Amount of which will be aqueduct filled per nth tick when dripping").worldRestart().defineInRange("drippingFillAmount", 1, 1, Integer.MAX_VALUE);
        this.drippingFillPerNthTick = builder.comment("How often should be filled aqueduct when dripping (1 - every tick, 20 - every second)").worldRestart().defineInRange("drippingFillPerNthTick", 20, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("valve");
        this.valveFillAmount = builder.comment("Amount of which will be aqueduct filled every nth tick thru valve").worldRestart().defineInRange("valveFillAmount", 1, 1, Integer.MAX_VALUE);
        this.valveFillPerNthTick = builder.comment("How often should be filled aqueduct thru valve (1 - every tick, 20 - every second)").worldRestart().defineInRange("valveFillPerNthTick", 10, 1, Integer.MAX_VALUE);
        this.valveChanceToDrainWater = builder.comment("Chance to drain water source (1 / n chance per random tick)").worldRestart().defineInRange("valveChanceToDrainWater", 1, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("hydrator");
        this.hydratorDrainAmount = builder.comment("Amount of which will be aqueduct drained every nth tick thru hydrator").worldRestart().defineInRange("hydratorDrainAmount", 100, 1, Integer.MAX_VALUE);
        this.hydratorDrainPerNthTick = builder.comment("How often should be drained aqueduct thru hydrator (1 - every tick, 20 - every second)").worldRestart().defineInRange("hydratorDrainPerNthTick", 200, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("fertilizer");
        this.fertilizerDuration = builder.comment("How long last single piece of fertilizer").worldRestart().defineInRange("fertilizerDuration", 600, 1, Integer.MAX_VALUE);
        this.applyFertilizerChance = builder.comment("How often should be applied bone meal effect (1 / n chance per tick)").worldRestart().defineInRange("applyFertilizerChance", 60, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("wellPulley");
        this.wellPulleyGeneration = builder.comment("How much water Well Pulley generate each 10 ticks").worldRestart().defineInRange("wellPulleyGeneration", 100, 1, Integer.MAX_VALUE);
        this.wetBiomeBonus = builder.comment("Bonus for Well Pulley generation in wet biome").worldRestart().defineInRange("wetBiomeBonus", 2.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.dryBiomeBonus = builder.comment("Bonus for Well Pulley generation in dry biome").worldRestart().defineInRange("dryBiomeBonus", 0.5, Double.MIN_VALUE, Double.MAX_VALUE);
        this.foodExhaustionOnUse = builder.comment("How much single use exhaust player").worldRestart().defineInRange("foodExhaustionOnUse", 0.5, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("wildAnimalsBreeding");
        this.minBreedingGenerations = builder.comment("Minimum generations for domestic animal breeding result").worldRestart().defineInRange("minBreedingGenerations", 3, 1, Integer.MAX_VALUE);
        this.domesticChance = builder.comment("Chance for domestic animal breeding result, multiplied by each generation after minBreedingGenerations").worldRestart().defineInRange("domesticChance", 0.2, Double.MIN_NORMAL, 1.0);
        this.removeVanillaMobs = builder.comment("If remove vanilla mobs spawning (sheeps, cows, chickens and pigs)").worldRestart().define("removeVanillaMobs", true);
        builder.pop();
        builder.push("smeltery");
        this.minSmelterTemperature = builder.comment("Base temperature of smeltery").worldRestart().defineInRange("minSmelterTemperature", 20, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.maxSmelterTemperature = builder.comment("Max temperature of smeltery without chimneys").worldRestart().defineInRange("maxSmelterTemperature", 900, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.temperaturePerChimney = builder.comment("How much chimney increase temperature in smeltery").worldRestart().defineInRange("temperaturePerChimney", 50, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public boolean hasFiniteWaterSource() {
        return (Boolean)this.finiteWaterSource.get();
    }

    public boolean cropsNeedWateredFarmland() {
        return (Boolean)this.cropsNeedWateredFarmland.get();
    }

    public boolean farmlandConsumesWater() {
        return (Boolean)this.farmlandConsumesWater.get();
    }

    public boolean noDryingDuringRain() {
        return (Boolean)this.noDryingDuringRain.get();
    }

    public int getBaseFluidStoragePerBlock() {
        return (Integer)this.baseFluidStoragePerBlock.get();
    }

    public boolean shouldRainingFillAqueduct() {
        return (Boolean)this.rainingFillAqueduct.get();
    }

    public int getRainingFillAmount() {
        return (Integer)this.rainingFillAmount.get();
    }

    public int getValveFillAmount() {
        return (Integer)this.valveFillAmount.get();
    }

    public int getValveFillPerNthTick() {
        return (Integer)this.valveFillPerNthTick.get();
    }

    public int getValveChanceToDrainWater() {
        return (Integer)this.valveChanceToDrainWater.get();
    }

    public int getHydratorDrainAmount() {
        return (Integer)this.hydratorDrainAmount.get();
    }

    public int getHydratorDrainPerNthTick() {
        return (Integer)this.hydratorDrainPerNthTick.get();
    }

    public int getRainingFillPerNthTick() {
        return (Integer)this.rainingFillPerNthTick.get();
    }

    public boolean isValidBlockForRaining() {
        return (Boolean)this.validBlockForRaining.get();
    }

    public boolean shouldDrippingFillAqueduct() {
        return (Boolean)this.drippingFillAqueduct.get();
    }

    public int getDrippingFillAmount() {
        return (Integer)this.drippingFillAmount.get();
    }

    public int getDrippingFillPerNthTick() {
        return (Integer)this.drippingFillPerNthTick.get();
    }

    public int getFertilizerDuration() {
        return (Integer)this.fertilizerDuration.get();
    }

    public int getApplyFertilizerChance() {
        return (Integer)this.applyFertilizerChance.get();
    }

    public int getWellPulleyGeneration() {
        return (Integer)this.wellPulleyGeneration.get();
    }

    public double getWellPulleyWetBonus() {
        return (Double)this.wetBiomeBonus.get();
    }

    public double getWellPulleyDryBonus() {
        return (Double)this.dryBiomeBonus.get();
    }

    public double getFoodExhaustionOnUse() {
        return (Double)this.foodExhaustionOnUse.get();
    }

    public int getMinBreedingGenerations() {
        return (Integer)this.minBreedingGenerations.get();
    }

    public double getDomesticChance() {
        return (Double)this.domesticChance.get();
    }

    public boolean removeVanillaMobs() {
        return (Boolean)this.removeVanillaMobs.get();
    }

    public int getMinSmelterTemperature() {
        return (Integer)this.minSmelterTemperature.get();
    }

    public int getMaxSmelterTemperature() {
        return (Integer)this.maxSmelterTemperature.get();
    }

    public int getTemperaturePerChimney() {
        return (Integer)this.temperaturePerChimney.get();
    }
}

