/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.NotNull;

public abstract class IrrigationBlock
extends BaseEntityBlock {
    public static final Map<Direction, Integer> ANGLE_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, 0);
        enumMap.put(Direction.EAST, 90);
        enumMap.put(Direction.SOUTH, 180);
        enumMap.put(Direction.WEST, 270);
    })));
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, BlockStateProperties.f_61368_);
        enumMap.put(Direction.EAST, BlockStateProperties.f_61369_);
        enumMap.put(Direction.SOUTH, BlockStateProperties.f_61370_);
        enumMap.put(Direction.WEST, BlockStateProperties.f_61371_);
    })));

    public IrrigationBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6810_(@NotNull BlockState oldBlockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newBlockState, boolean movedByPiston) {
        if (!level.f_46443_) {
            BlockEntity blockEntity;
            if (!(!oldBlockState.m_155947_() || oldBlockState.m_60713_(newBlockState.m_60734_()) && newBlockState.m_155947_())) {
                IIrrigationBlockEntity kineticBlockEntity;
                BlockEntity blockEntity2 = level.m_7702_(pos);
                if (blockEntity2 instanceof IIrrigationBlockEntity && (kineticBlockEntity = (IIrrigationBlockEntity)blockEntity2).getNetworkId() >= 0) {
                    kineticBlockEntity.onRemove();
                }
            } else if (oldBlockState.m_155947_() && oldBlockState.m_60713_(newBlockState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof IIrrigationBlockEntity) {
                IIrrigationBlockEntity kineticBlockEntity = (IIrrigationBlockEntity)blockEntity;
                kineticBlockEntity.onChangedState(oldBlockState, newBlockState);
            }
        }
        super.m_6810_(oldBlockState, level, pos, newBlockState, movedByPiston);
    }

    abstract List<BlockPos> getValidNeighbors(@NotNull BlockState var1, @NotNull BlockPos var2);

    static boolean isValidForConnection(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockPos neighborPos = pos.m_121955_(direction.m_122436_());
        BlockState blockState = level.m_8055_(neighborPos);
        Block block = blockState.m_60734_();
        if (block instanceof IrrigationBlock) {
            IrrigationBlock irrigationBlock = (IrrigationBlock)block;
            return irrigationBlock.getValidNeighbors(blockState, neighborPos).contains(pos);
        }
        return false;
    }
}

