/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlock
extends BaseEntityBlock {
    public MachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> entityType) {
        if (level.f_46443_) {
            if (this.hasClientTicker()) {
                return MachineBlock.m_152132_(entityType, entityType, MachineBlock::createMachineClientTicker);
            }
        } else if (this.hasServerTicker()) {
            return MachineBlock.m_152132_(entityType, entityType, MachineBlock::createMachineServerTicker);
        }
        return null;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MachineBlockEntity) {
            MachineBlockEntity blockEntity2 = (MachineBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getItemStackHandler().getItems());
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        if (!level.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.m_7246_(state, level, pos), (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean hasClientTicker() {
        return false;
    }

    public boolean hasServerTicker() {
        return false;
    }

    public static void createMachineClientTicker(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity block = (MachineBlockEntity)blockEntity;
            block.tickClient(level, pos, state, block);
        }
    }

    public static void createMachineServerTicker(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity block = (MachineBlockEntity)blockEntity;
            block.tickServer(level, pos, state, block);
        }
    }
}

