/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmphoraBlockEntity
extends BlockEntity {
    private static final String TAG_ITEM = "Item";
    private static final String TAG_COUNT = "Count";
    private static final int STACK_MULTIPLIER = 8;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            if (AmphoraBlockEntity.this.f_58857_ != null) {
                AmphoraBlockEntity.this.f_58857_.m_151543_(AmphoraBlockEntity.this.f_58858_);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41753_();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return stack.m_41741_() * 8;
        }

        public int getSlotLimit(int slot) {
            return 512;
        }
    };
    private LazyOptional<ItemStackHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public AmphoraBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.AMPHORA.get(), pPos, pBlockState);
    }

    public ItemStack getItem() {
        return this.itemHandler.getStackInSlot(0);
    }

    public InteractionResult onUse(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ItemStack holdingItem = player.m_21120_(hand);
        if (item.m_41619_()) {
            if (!holdingItem.m_41619_()) {
                this.itemHandler.setStackInSlot(0, holdingItem.m_278832_());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else {
            if (holdingItem.m_41619_()) {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)this.itemHandler.extractItem(0, player.m_6047_() ? item.m_41741_() : 1, false));
            } else {
                player.m_21008_(hand, this.itemHandler.insertItem(0, holdingItem, false));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(TAG_ITEM) && tag.m_128441_(TAG_COUNT)) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ITEM));
            int count = tag.m_128451_(TAG_COUNT);
            itemStack.m_41764_(count);
            this.itemHandler.setStackInSlot(0, itemStack);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.f_58859_ && side == Direction.UP) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        tag.m_128365_(TAG_ITEM, (Tag)itemStack.m_41739_(new CompoundTag()));
        tag.m_128405_(TAG_COUNT, itemStack.m_41613_());
    }
}

