/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block_entity.SimpleProgressHandler;
import com.yanny.ytech.configuration.recipe.HammeringRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import com.yanny.ytech.registration.YTechSoundEvents;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BronzeAnvilBlockEntity
extends BlockEntity {
    private final SimpleProgressHandler<HammeringRecipe> progressHandler = new SimpleProgressHandler((RecipeType)YTechRecipeTypes.HAMMERING.get());

    public BronzeAnvilBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.BRONZE_ANVIL.get(), pos, blockState);
    }

    public int getProgress() {
        return this.progressHandler.getProgress();
    }

    public ItemStack getItem() {
        return this.progressHandler.getItem();
    }

    public InteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.f_46443_) {
            ItemStack holdingItemStack = player.m_21120_(hand);
            if (this.progressHandler.isEmpty()) {
                if (!this.progressHandler.setupCrafting(level, holdingItemStack, HammeringRecipe::hitCount)) {
                    this.progressHandler.setupCrafting(level, player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), HammeringRecipe::hitCount);
                }
            } else {
                Function<HammeringRecipe, Boolean> canProcess = recipe -> recipe.tool().m_43947_() || recipe.tool().test(holdingItemStack);
                Function<HammeringRecipe, Float> getStep = recipe -> Float.valueOf(1.0f);
                BiConsumer<Container, HammeringRecipe> onFinish = (container, recipe) -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recipe.m_5874_((Container)container, level.m_9598_()));
                Function<ItemStack, Container> getContainer = item -> new SimpleContainer(new ItemStack[]{item, holdingItemStack});
                if (!this.progressHandler.tick(level, canProcess, getStep, onFinish, getContainer)) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)this.progressHandler.getItem());
                    this.progressHandler.clear();
                } else {
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                    level.m_5594_(null, pos, (SoundEvent)YTechSoundEvents.BRONZE_ANVIL_USE.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                }
            }
            level.m_7260_(pos, state, state, 3);
            level.m_151543_(pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progressHandler.load(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.progressHandler.save(tag);
    }
}

