/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block_entity.SimpleProgressHandler;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class FirePitBlockEntity
extends BlockEntity
implements BlockEntityTicker<FirePitBlockEntity> {
    private final SimpleProgressHandler<CampfireCookingRecipe> progressHandler = new SimpleProgressHandler(RecipeType.f_44111_);

    public FirePitBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.FIRE_PIT.get(), pPos, pBlockState);
    }

    public ItemStack getItem() {
        return this.progressHandler.getItem();
    }

    public int getProgress() {
        return this.progressHandler.getProgress();
    }

    public InteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.f_46443_) {
            ItemStack holdingItemStack = player.m_21120_(hand);
            if (this.progressHandler.isEmpty()) {
                this.progressHandler.setupCrafting(level, holdingItemStack, AbstractCookingRecipe::m_43753_);
            } else {
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)this.progressHandler.getItem());
                this.progressHandler.clear();
            }
            level.m_7260_(pos, state, state, 3);
            level.m_151543_(pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FirePitBlockEntity blockEntity) {
        BiConsumer<Container, CampfireCookingRecipe> onFinish;
        Function<CampfireCookingRecipe, Float> getStep;
        int heatLevel = (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_);
        Function<CampfireCookingRecipe, Boolean> canProcess = recipe -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false && heatLevel > 0;
        if (this.progressHandler.tick(level, canProcess, getStep = recipe -> Float.valueOf((float)heatLevel / 15.0f), onFinish = (container, recipe) -> {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)recipe.m_5874_(container, level.m_9598_()));
            level.m_7260_(pos, state, state, 3);
            level.m_151543_(pos);
        }, xva$0 -> new SimpleContainer(new ItemStack[]{xva$0}))) {
            FirePitBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progressHandler.load(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.progressHandler.save(tag);
    }
}

