/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.entity.GoAroundEntity;
import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends BlockEntity {
    private static final String TAG_INPUT = "input";
    private static final String TAG_RESULT = "result";
    private static final String TAG_BONUS_CHANCE = "bonusChance";
    private static final String TAG_IS_MILLING = "isMilling";
    private static final String TAG_IS_LEASHED = "isLeashed";
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack result = ItemStack.f_41583_;
    private float bonusChance = 0.0f;
    private boolean isMilling = false;
    private boolean isLeashed = false;
    @Nullable
    private GoAroundEntity entity = null;
    private final RecipeManager.CachedCheck<Container, MillingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)YTechRecipeTypes.MILLING.get()));

    public MillstoneBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.MILLSTONE.get(), pos, blockState);
    }

    public InteractionResult onUse(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            if (!this.isLeashed) {
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                List mobList = level.m_45976_(Mob.class, new AABB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0));
                for (Mob mob : mobList) {
                    if (mob.m_21524_() != player || !mob.m_20197_().isEmpty()) continue;
                    mob.m_21455_(true, false);
                    GoAroundEntity mimic = new GoAroundEntity(mob, pos, level);
                    level.m_7967_((Entity)mimic);
                    mimic.m_7998_((Entity)mob, true);
                    break;
                }
            }
            ItemStack holdingItemStack = player.m_21120_(hand);
            if (this.result.m_41619_() && this.isLeashed && !holdingItemStack.m_41619_()) {
                Optional millingRecipe = this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{holdingItemStack}), level);
                millingRecipe.ifPresent(r -> {
                    EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    this.input = holdingItemStack.m_255036_(holdingItemStack.m_41613_() - 1);
                    this.result = r.result();
                    this.bonusChance = r.bonusChance();
                    this.isMilling = true;
                    player.m_8061_(slot, ItemStack.f_41583_);
                    MillstoneBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
                });
            }
            if (player.m_6047_() && player.m_21120_(hand).m_41619_() && this.isLeashed && this.entity != null) {
                this.entity.m_8127_();
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.input = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_INPUT));
        this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RESULT));
        this.bonusChance = tag.m_128457_(TAG_BONUS_CHANCE);
        this.isMilling = tag.m_128471_(TAG_IS_MILLING);
        this.isLeashed = tag.m_128471_(TAG_IS_LEASHED);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isMilling() {
        return this.isMilling;
    }

    public void onFinished() {
        if (this.f_58857_ != null && !this.result.m_41619_()) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)this.result.m_41777_());
            if (this.f_58857_.f_46441_.m_188501_() < this.bonusChance) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)this.result.m_255036_(1));
            }
            if (this.input.m_41619_()) {
                this.isMilling = false;
                this.result = ItemStack.f_41583_;
            } else {
                this.input.m_41764_(this.input.m_41613_() - 1);
            }
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11998_, SoundSource.BLOCKS, this.f_58857_.f_46441_.m_188501_() * 0.25f + 0.75f, this.f_58857_.f_46441_.m_188501_() + 0.5f);
            MillstoneBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
        }
    }

    public void removeLeash() {
        if (this.f_58857_ != null) {
            this.isLeashed = false;
            this.entity = null;
            this.isMilling = false;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            MillstoneBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
        }
    }

    public void setLeashed(@NotNull GoAroundEntity entity) {
        if (this.f_58857_ != null) {
            this.entity = entity;
            this.isLeashed = true;
            if (!this.input.m_41619_() && !this.result.m_41619_()) {
                this.isMilling = true;
            }
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            MillstoneBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
        }
    }

    public void onRemove() {
        if (this.entity != null) {
            this.entity.m_8127_();
        }
    }

    public boolean isLeashed() {
        return this.isLeashed;
    }

    public ItemStack getInputItem() {
        return this.input;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_INPUT, (Tag)this.input.m_41739_(new CompoundTag()));
        tag.m_128365_(TAG_RESULT, (Tag)this.result.m_41739_(new CompoundTag()));
        tag.m_128350_(TAG_BONUS_CHANCE, this.bonusChance);
        tag.m_128379_(TAG_IS_MILLING, this.isMilling);
        tag.m_128379_(TAG_IS_LEASHED, this.isLeashed);
    }
}

