/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.container.PrimitiveSmelterContainerMenu;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveSmelterBlockEntity
extends AbstractPrimitiveMachineBlockEntity {
    private static final String TAG_RECIPE_INPUT = "recipeInput";
    private static final String TAG_RECIPE_MOLD = "recipeMold";
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_MOLD = 2;
    private static final int SLOT_OUTPUT = 3;
    private final RecipeManager.CachedCheck<Container, SmeltingRecipe> quickCheck;
    @Nullable
    private ItemStack recipeInput = ItemStack.f_41583_;
    @Nullable
    private ItemStack recipeMold = ItemStack.f_41583_;

    public PrimitiveSmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.PRIMITIVE_SMELTER.get(), pos, blockState, (RecipeType)YTechRecipeTypes.SMELTING.get());
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)YTechRecipeTypes.SMELTING.get()));
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.ytech.primitive_smelter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new PrimitiveSmelterContainerMenu(windowId, inventory.f_35978_, this.f_58858_, this.itemStackHandler, this.containerData);
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(55, 16).addInputSlot(55, 52, (itemStackHandler, slot, itemStack) -> ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44109_) > 0).addInputSlot(88, 52, (itemStackHandler, slot, itemStack) -> itemStack.m_204117_(YTechItemTags.CLAY_MOLDS.tag) || itemStack.m_204117_(YTechItemTags.SAND_MOLDS.tag)).addOutputSlot(116, 35).setOnChangeListener(() -> ((PrimitiveSmelterBlockEntity)this).m_6596_()).build();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.recipeInput = tag.m_128441_(TAG_RECIPE_INPUT) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RECIPE_INPUT)) : null;
            this.recipeMold = tag.m_128441_(TAG_RECIPE_MOLD) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RECIPE_MOLD)) : null;
        }
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.recipeInput != null;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            CompoundTag itemStack;
            if (this.recipeInput != null) {
                itemStack = new CompoundTag();
                this.recipeInput.m_41739_(itemStack);
                tag.m_128365_(TAG_RECIPE_INPUT, (Tag)itemStack);
            }
            if (this.recipeMold != null) {
                itemStack = new CompoundTag();
                this.recipeMold.m_41739_(itemStack);
                tag.m_128365_(TAG_RECIPE_MOLD, (Tag)itemStack);
            }
        }
    }

    @Override
    protected boolean hasItemsInInput() {
        return !this.itemStackHandler.getStackInSlot(0).m_41619_();
    }

    @Override
    protected int getFuelSlot() {
        return 1;
    }

    @Override
    protected void startRecipe(@NotNull AtomicBoolean hasChanged) {
        if (this.f_58857_ != null) {
            ItemStack input = this.itemStackHandler.getStackInSlot(0);
            ItemStack mold = this.itemStackHandler.getStackInSlot(2);
            this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{input, mold}), this.f_58857_).ifPresent(r -> {
                ItemStack result = this.itemStackHandler.getStackInSlot(3);
                if (r.minTemperature() <= this.temperature && (result.m_41619_() || ItemStack.m_150942_((ItemStack)result, (ItemStack)r.result()) && result.m_41741_() > result.m_41613_())) {
                    this.recipeInput = input.m_41620_(r.inputCount());
                    this.recipeMold = mold.m_41777_();
                    this.leftSmelting = this.smeltingTime = r.smeltingTime();
                    this.recipeTemperature = r.minTemperature();
                    hasChanged.set(true);
                    if (!r.mold().m_43947_()) {
                        if (mold.m_41763_()) {
                            if (mold.m_220157_(1, this.f_58857_.f_46441_, null)) {
                                mold.m_41774_(1);
                            }
                        } else {
                            mold.m_41774_(1);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void finishRecipe() {
        if (this.f_58857_ != null) {
            ItemStack result = this.itemStackHandler.getStackInSlot(3);
            this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{this.recipeInput, this.recipeMold}), this.f_58857_).ifPresent(r -> {
                if (result.m_41619_()) {
                    this.itemStackHandler.setStackInSlot(3, r.result().m_41777_());
                } else {
                    result.m_41769_(1);
                }
            });
            this.recipeInput = null;
            this.recipeMold = null;
        }
    }

    @Override
    protected boolean isValidRecipeInInput() {
        if (this.f_58857_ != null) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
            ItemStack mold = this.itemStackHandler.getStackInSlot(2);
            return this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{itemStack, mold}), this.f_58857_).isPresent();
        }
        return false;
    }
}

