/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

class SimpleProgressHandler<R extends Recipe<Container>> {
    private static final String TAG_ITEM = "Item";
    private static final String TAG_TIME = "Time";
    private static final String TAG_TOTAL_TIME = "TotalTime";
    private ItemStack item = ItemStack.f_41583_;
    private float progress = 0.0f;
    private int total = 0;
    private final RecipeManager.CachedCheck<Container, R> quickCheck;

    public SimpleProgressHandler(RecipeType<R> recipeType) {
        this.quickCheck = RecipeManager.m_220267_(recipeType);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean isEmpty() {
        return this.item.m_41619_();
    }

    public int getProgress() {
        return Math.round(this.progress / (float)this.total * 100.0f);
    }

    public void clear() {
        this.total = 0;
        this.progress = 0.0f;
        this.item = ItemStack.f_41583_;
    }

    public boolean setupCrafting(@NotNull Level level, ItemStack input, Function<R, Integer> recipeTimeGetter) {
        Optional recipeHolder = this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{input}), level);
        if (recipeHolder.isPresent()) {
            this.total = recipeTimeGetter.apply((Recipe)recipeHolder.get());
            this.item = input.m_41620_(1);
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean tick(@NotNull Level level, Function<R, Boolean> canProcess, Function<R, Float> recipeStepGetter, BiConsumer<Container, R> onFinish, Function<ItemStack, Container> containerGetter) {
        Recipe recipe;
        Container container;
        Optional recipeHolder;
        if (!this.item.m_41619_() && (recipeHolder = this.quickCheck.m_213657_(container = containerGetter.apply(this.item), level)).isPresent() && canProcess.apply(recipe = (Recipe)recipeHolder.get()).booleanValue()) {
            ItemStack result;
            this.progress += recipeStepGetter.apply(recipe).floatValue();
            if (this.progress >= (float)this.total && (result = recipe.m_8043_(level.m_9598_())).m_246617_(level.m_246046_())) {
                this.clear();
                onFinish.accept(container, recipe);
            }
            return true;
        }
        return false;
    }

    public void load(@NotNull CompoundTag tag) {
        this.item = tag.m_128441_(TAG_ITEM) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ITEM)) : ItemStack.f_41583_;
        if (tag.m_128441_(TAG_TIME)) {
            this.progress = tag.m_128457_(TAG_TIME);
        }
        if (tag.m_128441_(TAG_TOTAL_TIME)) {
            this.total = tag.m_128451_(TAG_TOTAL_TIME);
        }
    }

    public void save(@NotNull CompoundTag tag) {
        tag.m_128365_(TAG_ITEM, (Tag)this.item.m_41739_(new CompoundTag()));
        tag.m_128350_(TAG_TIME, this.progress);
        tag.m_128405_(TAG_TOTAL_TIME, this.total);
    }
}

