/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import com.yanny.ytech.configuration.container.StrainerContainerMenu;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrainerBlockEntity
extends MachineBlockEntity {
    public StrainerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.STRAINER.get(), pPos, pBlockState);
    }

    public boolean hasMesh() {
        return !this.itemStackHandler.getStackInSlot(0).m_41619_();
    }

    public void onRandomTick(ServerLevel serverLevel, BlockPos pos) {
        BlockState aboveState = serverLevel.m_8055_(pos.m_7494_());
        if (aboveState.m_60713_(Blocks.f_49990_) && !aboveState.m_60819_().m_76170_()) {
            float flowingLevel = ((Integer)aboveState.m_60819_().m_61143_((Property)BlockStateProperties.f_61420_)).intValue();
            if (serverLevel.f_46441_.m_188500_() <= (double)(flowingLevel / 7.0f)) {
                MinecraftServer server = serverLevel.m_7654_();
                LootTable table = server.m_278653_().m_278676_(Utils.modLoc("fishing/strainer"));
                ItemStack mesh = this.itemStackHandler.getStackInSlot(0);
                ObjectArrayList randomItems = table.m_287195_(new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)pos.m_252807_()).m_287286_(LootContextParams.f_81463_, (Object)this.itemStackHandler.getStackInSlot(0)).m_287235_(LootContextParamSets.f_81414_));
                if (mesh.m_220157_(1, serverLevel.f_46441_, null)) {
                    mesh.m_41774_(1);
                    mesh.m_41721_(0);
                }
                this.itemStackHandler.setStackInSlot(0, mesh);
                this.itemStackHandler.outputOperation(() -> randomItems.forEach(itemStack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)itemStack, (boolean)false)));
            }
        }
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        MachineItemStackHandler.Builder builder = new MachineItemStackHandler.Builder().addInputSlot(26, 34, (handler, slot, stack) -> stack.m_204117_(YTechItemTags.MESHES.tag)).setOnChangeListener(this::onChanged);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                builder.addOutputSlot(8 + (x + 4) * 18, 16 + y * 18);
            }
        }
        return builder.build();
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new SimpleContainerData(0);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.ytech.strainer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new StrainerContainerMenu(windowId, inventory.f_35978_, this.f_58858_, this.itemStackHandler, this.containerData);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void onChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }
}

