/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.entity.SaberToothTigerEntity;
import com.yanny.ytech.configuration.entity.WildDangerousEntity;
import com.yanny.ytech.configuration.goal.IRaidGarden;
import com.yanny.ytech.configuration.goal.RaidGardenGoal;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AurochsEntity
extends WildDangerousEntity
implements IRaidGarden {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final String TAG_MORE_WHEAT_TICKS = "MoreWheatTicks";
    private int moreWheatTicks;
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;

    public AurochsEntity(EntityType<? extends WildDangerousEntity> entityType, Level level) {
        super(entityType, level);
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.6f;
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return pStack.m_204117_(YTechItemTags.AUROCHS_FOOD);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public boolean wantsMoreFood() {
        return this.moreWheatTicks <= 0;
    }

    @Override
    public void setWantsMoreFoodTicks() {
        this.moreWheatTicks = 40;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_(TAG_MORE_WHEAT_TICKS, this.moreWheatTicks);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.moreWheatTicks = tag.m_128451_(TAG_MORE_WHEAT_TICKS);
    }

    public float getHeadEatPositionScale(float pPartialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pPartialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - pPartialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float pPartialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - pPartialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    protected EntityType<? extends AgeableMob> getDomesticBreedOffspring() {
        return EntityType.f_20557_;
    }

    @Override
    protected Class<? extends WildDangerousEntity> getMineClass() {
        return AurochsEntity.class;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(YTechItemTags.AUROCHS_TEMP_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, SaberToothTigerEntity.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(6, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(6, new RaidGardenGoal<AurochsEntity>(this, YTechBlockTags.AUROCHS_RAID_BLOCKS));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerTargetGoals();
    }

    @Override
    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.m_25213_();
        super.m_8024_();
        if (this.moreWheatTicks > 0) {
            this.moreWheatTicks -= this.f_19796_.m_188503_(3);
            if (this.moreWheatTicks < 0) {
                this.moreWheatTicks = 0;
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22281_, 5.0);
    }
}

