/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.entity.WildAnimalEntity;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WildDangerousEntity
extends WildAnimalEntity
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("1726b8b1-a40a-4db1-9d6b-9f3fa8826166");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> DATA_GENERATION_ID = SynchedEntityData.m_135353_(WildDangerousEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final UniformInt FIRST_ANGER_SOUND_DELAY = TimeUtil.m_145020_((int)0, (int)1);
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
    private int ticksUntilNextAlert;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int playFirstAngerSoundIn;

    protected WildDangerousEntity(EntityType<? extends WildDangerousEntity> entityType, Level level) {
        super(entityType, level);
    }

    abstract Class<? extends WildDangerousEntity> getMineClass();

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
    }

    public void m_6710_(@Nullable LivingEntity pLivingEntity) {
        if (this.m_5448_() == null && pLivingEntity != null) {
            this.playFirstAngerSoundIn = FIRST_ANGER_SOUND_DELAY.m_214085_(this.f_19796_);
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
        if (pLivingEntity instanceof Player) {
            this.m_6598_((Player)pLivingEntity);
        }
        super.m_6710_(pLivingEntity);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GENERATION_ID, (Object)0);
    }

    protected void registerTargetGoals() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WildDangerousEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8024_() {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance != null) {
            if (this.m_21660_()) {
                if (!this.m_6162_() && !attributeInstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                    attributeInstance.m_22118_(SPEED_MODIFIER_ATTACKING);
                }
                this.maybePlayFirstAngerSound();
            } else if (attributeInstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeInstance.m_22130_(SPEED_MODIFIER_ATTACKING);
            }
        }
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_5448_() != null) {
            this.maybeAlertOthers();
        }
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        super.m_8024_();
    }

    private void maybePlayFirstAngerSound() {
        if (this.playFirstAngerSoundIn > 0) {
            --this.playFirstAngerSoundIn;
            if (this.playFirstAngerSoundIn == 0) {
                this.playAngerSound();
            }
        }
    }

    private void playAngerSound() {
        this.m_5496_(Objects.requireNonNull(this.m_5592_()), this.m_6121_() * 2.0f, this.m_6100_() * 0.8f);
    }

    private void maybeAlertOthers() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)Objects.requireNonNull(this.m_5448_()))) {
                this.alertOthers();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    private void alertOthers() {
        double followRange = this.m_21133_(Attributes.f_22277_);
        AABB area = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(followRange, 10.0, followRange);
        this.m_9236_().m_6443_(this.getMineClass(), area, EntitySelector.f_20408_).stream().filter(animal -> animal != this).filter(animal -> animal.m_5448_() == null).filter(animal -> !animal.m_7307_((Entity)Objects.requireNonNull(this.m_5448_()))).forEach(animal -> animal.m_6710_(this.m_5448_()));
    }
}

