/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.configuration.Utils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasketItem
extends Item {
    public static final ResourceLocation FILLED_PREDICATE = Utils.modLoc("filled");
    private static final String TAG_ITEMS = "items";
    public static final int MAX_WEIGHT = 16;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public BasketItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return 300;
    }

    public static float getFullnessDisplay(@NotNull ItemStack stack) {
        return (float)BasketItem.getContentWeight(stack) / 16.0f;
    }

    public boolean m_142207_(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (stack.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = slot.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            BasketItem.removeOne(stack).ifPresent(itemStack -> BasketItem.add(stack, slot.m_150659_(itemStack)));
        } else if (itemstack.m_41720_().m_142095_()) {
            int i = (16 - BasketItem.getContentWeight(stack)) / BasketItem.getWeight(itemstack);
            int j = BasketItem.add(stack, slot.m_150647_(itemstack.m_41613_(), i, player));
            if (j > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (other.m_41619_()) {
                BasketItem.removeOne(stack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((Entity)player);
                    access.m_142104_(itemStack);
                });
            } else {
                int i = BasketItem.add(stack, other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                    other.m_41774_(i);
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (BasketItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return BasketItem.getContentWeight(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(1 + 12 * BasketItem.getContentWeight(stack) / 16, 13);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return BAR_COLOR;
    }

    private static int add(@NotNull ItemStack bundleStack, @NotNull ItemStack insertedStack) {
        if (!insertedStack.m_41619_() && insertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = bundleStack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = BasketItem.getContentWeight(bundleStack);
            int j = BasketItem.getWeight(insertedStack);
            int k = Math.min(insertedStack.m_41613_(), (16 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag list = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = BasketItem.getMatchingItem(insertedStack, list);
            if (optional.isPresent()) {
                CompoundTag matching = optional.get();
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)matching);
                itemStack.m_41769_(k);
                itemStack.m_41739_(matching);
                list.remove((Object)matching);
                list.add(0, (Tag)matching);
            } else {
                ItemStack itemStack = insertedStack.m_255036_(k);
                CompoundTag tag = new CompoundTag();
                itemStack.m_41739_(tag);
                list.add(0, (Tag)tag);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(@NotNull ItemStack stack, @NotNull ListTag list) {
        return stack.m_150930_(Items.f_151058_) ? Optional.empty() : list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(tag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)tag), (ItemStack)stack)).findFirst();
    }

    private static int getWeight(@NotNull ItemStack stack) {
        CompoundTag compoundtag;
        if (stack.m_150930_(Items.f_151058_)) {
            return 4 + BasketItem.getContentWeight(stack);
        }
        if ((stack.m_150930_(Items.f_42786_) || stack.m_150930_(Items.f_42785_)) && stack.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)stack)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 16;
        }
        return 16 / Math.min(stack.m_41741_(), 16);
    }

    private static int getContentWeight(ItemStack stack) {
        return BasketItem.getContents(stack).mapToInt(itemStack -> BasketItem.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    private static Optional<ItemStack> removeOne(@NotNull ItemStack stack) {
        CompoundTag compoundtag = stack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag list = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag itemTag = list.m_128728_(0);
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
        list.remove(0);
        if (list.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemStack);
    }

    private static boolean dropContents(@NotNull ItemStack stack, @NotNull Player player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag list = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compoundTag = list.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundTag);
                player.m_36176_(itemstack, true);
            }
        }
        stack.m_41749_(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Stream.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        return list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        BasketItem.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, BasketItem.getContentWeight(stack)));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{BasketItem.getContentWeight(stack), 16}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(@NotNull ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, BasketItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(@NotNull Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(@NotNull Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(@NotNull Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

