/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.AurochsEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AurochsModel
extends AgeableListModel<AurochsEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("aurochs"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart fl_foot;
    @NotNull
    private final ModelPart bl_foot;
    @NotNull
    private final ModelPart fr_foot;
    @NotNull
    private final ModelPart br_foot;
    private float headXRot;

    public AurochsModel(@NotNull ModelPart root) {
        super(false, 10.0f, 5.0f);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.fl_foot = root.m_171324_("fl_foot");
        this.bl_foot = root.m_171324_("bl_foot");
        this.fr_foot = root.m_171324_("fr_foot");
        this.br_foot = root.m_171324_("br_foot");
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.fl_foot, (Object)this.bl_foot, (Object)this.fr_foot, (Object)this.br_foot);
    }

    public void setupAnim(@NotNull AurochsEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = this.headXRot;
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.fl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.bl_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.fr_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.br_foot.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.head.m_171324_((String)"horns").f_104207_ = !entity.m_6162_();
    }

    public void prepareMobModel(@NotNull AurochsEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.m_6839_((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.head.f_104201_ = 3.0f + pEntity.getHeadEatPositionScale(pPartialTick) * (pEntity.m_6162_() ? 3.0f : 9.0f);
        this.headXRot = pEntity.getHeadEatAngleScale(pPartialTick);
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -5.75f, -6.5f, 12.0f, 13.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-5.0f, -6.75f, -8.5f, 10.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.75f, (float)-1.5f));
        partdefinition.m_171599_("fl_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.m_171599_("bl_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)9.0f));
        partdefinition.m_171599_("fr_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.m_171599_("br_foot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)9.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(34, 49).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-10.0f));
        PartDefinition horns = head.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(4.0f, -4.0f, -3.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(44, 16).m_171488_(-8.0f, -4.0f, -3.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        horns.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(6.9853f, -3.5f, 3.4497f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 0).m_171488_(-4.7426f, -3.5f, -9.2782f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

