/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block_entity.AqueductBlockEntity;
import com.yanny.ytech.configuration.renderer.FakeAqueductLevel;
import com.yanny.ytech.configuration.renderer.FluidVertexConsumer;
import com.yanny.ytech.network.irrigation.IrrigationClientNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AqueductRenderer
implements BlockEntityRenderer<AqueductBlockEntity> {
    private static final FakeAqueductLevel level = new FakeAqueductLevel();
    private final BlockState water = (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(8));

    public AqueductRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull AqueductBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        IrrigationClientNetwork network = YTechMod.IRRIGATION_PROPAGATOR.client().getNetwork(blockEntity);
        if (network != null && network.getCapacity() > 0 && network.getAmount() > 0) {
            level.setData(blockEntity, this.water);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.75 + (double)((float)network.getAmount() / (float)network.getCapacity()) * 0.75, 0.0);
            PoseStack.Pose pose = poseStack.m_85850_();
            FluidVertexConsumer builder = new FluidVertexConsumer(buffer, this.water.m_60819_(), pose.m_252922_(), pose.m_252943_());
            Minecraft.m_91087_().m_91289_().m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)level, (VertexConsumer)builder, this.water, this.water.m_60819_());
            poseStack.m_85849_();
            level.clearData();
        }
    }
}

