/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

class YTechBlockTagsProvider
extends BlockTagsProvider {
    public YTechBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "ytech", existingFileHelper);
    }

    protected void m_6577_(@NotNull HolderLookup.Provider provider) {
        this.m_206424_(YTechBlockTags.AMPHORAE).m_255245_((Object)((Block)YTechBlocks.AMPHORA.get()));
        this.m_206424_(YTechBlockTags.AQUEDUCT_FERTILIZERS).m_255245_((Object)((Block)YTechBlocks.AQUEDUCT_FERTILIZER.get()));
        this.m_206424_(YTechBlockTags.AQUEDUCT_HYDRATORS).m_255245_((Object)((Block)YTechBlocks.AQUEDUCT_HYDRATOR.get()));
        this.m_206424_(YTechBlockTags.AQUEDUCT_VALVES).m_255245_((Object)((Block)YTechBlocks.AQUEDUCT_VALVE.get()));
        this.m_206424_(YTechBlockTags.BRICK_CHIMNEYS).m_255245_((Object)((Block)YTechBlocks.BRICK_CHIMNEY.get()));
        this.m_206424_(YTechBlockTags.BRONZE_ANVILS).m_255245_((Object)((Block)YTechBlocks.BRONZE_ANVIL.get()));
        this.m_206424_(YTechBlockTags.CRAFTING_WORKSPACES).m_255245_((Object)((Block)YTechBlocks.CRAFTING_WORKSPACE.get()));
        this.m_206424_(YTechBlockTags.FIRE_PITS).m_255245_((Object)((Block)YTechBlocks.FIRE_PIT.get()));
        this.m_206424_(YTechBlockTags.GRASS_BEDS).m_255245_((Object)((Block)YTechBlocks.GRASS_BED.get()));
        this.m_206424_(YTechBlockTags.MILLSTONES).m_255245_((Object)((Block)YTechBlocks.MILLSTONE.get()));
        this.m_206424_(YTechBlockTags.POTTERS_WHEELS).m_255245_((Object)((Block)YTechBlocks.POTTERS_WHEEL.get()));
        this.m_206424_(YTechBlockTags.PRIMITIVE_ALLOY_SMELTERS).m_255245_((Object)((Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get()));
        this.m_206424_(YTechBlockTags.PRIMITIVE_SMELTERS).m_255245_((Object)((Block)YTechBlocks.PRIMITIVE_SMELTER.get()));
        this.m_206424_(YTechBlockTags.REINFORCED_BRICKS).m_255245_((Object)((Block)YTechBlocks.REINFORCED_BRICKS.get()));
        this.m_206424_(YTechBlockTags.REINFORCED_BRICK_CHIMNEYS).m_255245_((Object)((Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get()));
        this.m_206424_(YTechBlockTags.STRAINERS).m_255245_((Object)((Block)YTechBlocks.STRAINER.get()));
        this.m_206424_(YTechBlockTags.TERRACOTTA_BRICKS).m_255245_((Object)((Block)YTechBlocks.TERRACOTTA_BRICKS.get()));
        this.m_206424_(YTechBlockTags.TERRACOTTA_BRICK_SLABS).m_255245_((Object)((Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get()));
        this.m_206424_(YTechBlockTags.TERRACOTTA_BRICK_STAIRS).m_255245_((Object)((Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get()));
        this.m_206424_(YTechBlockTags.THATCH).m_255245_((Object)((Block)YTechBlocks.THATCH.get()));
        this.m_206424_(YTechBlockTags.THATCH_SLABS).m_255245_((Object)((Block)YTechBlocks.THATCH_SLAB.get()));
        this.m_206424_(YTechBlockTags.THATCH_STAIRS).m_255245_((Object)((Block)YTechBlocks.THATCH_STAIRS.get()));
        this.m_206424_(YTechBlockTags.TOOL_RACKS).m_255245_((Object)((Block)YTechBlocks.TOOL_RACK.get()));
        this.m_206424_(YTechBlockTags.TREE_STUMPS).m_255245_((Object)((Block)YTechBlocks.TREE_STUMP.get()));
        this.m_206424_(YTechBlockTags.WELL_PULLEYS).m_255245_((Object)((Block)YTechBlocks.WELL_PULLEY.get()));
        this.m_206424_(YTechBlockTags.WOODEN_BOXES).m_255245_((Object)((Block)YTechBlocks.WOODEN_BOX.get()));
        this.m_206424_(YTechBlockTags.AUROCHS_RAID_BLOCKS).m_255245_((Object)Blocks.f_50092_);
        this.m_206424_(YTechBlockTags.DEER_RAID_BLOCKS).m_255245_((Object)Blocks.f_50092_);
        this.m_206424_(YTechBlockTags.FOWL_RAID_BLOCKS).m_255245_((Object)Blocks.f_50444_);
        this.m_206424_(YTechBlockTags.MOUFLON_RAID_BLOCKS).m_255179_((Object[])new Block[]{Blocks.f_50092_, Blocks.f_50444_, Blocks.f_50189_, Blocks.f_50187_, Blocks.f_50190_, Blocks.f_50188_});
        this.m_206424_(YTechBlockTags.FIRE_SOURCE).m_255179_((Object[])new Block[]{Blocks.f_50083_, Blocks.f_50683_, Blocks.f_50681_, Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50094_, Blocks.f_50620_}).m_206428_(YTechBlockTags.FIRE_PITS).m_206428_(YTechBlockTags.PRIMITIVE_SMELTERS).m_206428_(YTechBlockTags.PRIMITIVE_ALLOY_SMELTERS);
        this.m_206424_(YTechBlockTags.SOUL_FIRE_SOURCE).m_255179_((Object[])new Block[]{Blocks.f_50084_, Blocks.f_50684_, Blocks.f_50682_, Blocks.f_50139_, Blocks.f_50140_});
        this.m_206424_(YTechBlockTags.REQUIRE_VALID_TOOL).m_206428_(BlockTags.f_13106_).m_206428_(BlockTags.f_144274_);
        this.materialTag(YTechBlocks.AQUEDUCTS, YTechBlockTags.AQUEDUCTS);
        this.materialOreTag(YTechBlocks.DEEPSLATE_ORES, YTechBlockTags.DEEPSLATE_ORES, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.DRYING_RACKS, YTechBlockTags.DRYING_RACKS);
        this.materialTag(YTechBlocks.GRAVEL_DEPOSITS, YTechBlockTags.GRAVEL_DEPOSITS);
        this.materialOreTag(YTechBlocks.NETHER_ORES, YTechBlockTags.NETHER_ORES, EnumSet.of(MaterialType.GOLD));
        this.materialTag(YTechBlocks.RAW_STORAGE_BLOCKS, YTechBlockTags.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.SAND_DEPOSITS, YTechBlockTags.SAND_DEPOSITS);
        this.materialOreTag(YTechBlocks.STONE_ORES, YTechBlockTags.STONE_ORES, MaterialType.VANILLA_METALS);
        this.tieredMaterialTag(YTechBlocks.STORAGE_BLOCKS, YTechBlockTags.STORAGE_BLOCKS, MaterialType.VANILLA_METALS);
        this.materialTag(YTechBlocks.TANNING_RACKS, YTechBlockTags.TANNING_RACKS);
        this.m_206424_(BlockTags.f_13033_).m_255245_((Object)((Block)YTechBlocks.BRONZE_ANVIL.get()));
        this.m_206424_(BlockTags.f_13038_).m_255245_((Object)((Block)YTechBlocks.GRASS_BED.get()));
        this.m_206424_(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS));
        this.m_206424_(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD)));
        this.m_206424_(Tags.Blocks.ORES_IN_GROUND_STONE).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS));
        this.m_206424_(BlockTags.f_13031_).m_255179_((Object[])new Block[]{(Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.THATCH_SLAB.get()});
        this.m_206424_(BlockTags.f_13030_).m_255179_((Object[])new Block[]{(Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get(), (Block)YTechBlocks.THATCH_STAIRS.get()});
        this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{(Block)YTechBlocks.AMPHORA.get(), (Block)YTechBlocks.AQUEDUCT_FERTILIZER.get(), (Block)YTechBlocks.AQUEDUCT_HYDRATOR.get(), (Block)YTechBlocks.AQUEDUCT_VALVE.get(), (Block)YTechBlocks.BRICK_CHIMNEY.get(), (Block)YTechBlocks.BRONZE_ANVIL.get(), (Block)YTechBlocks.MILLSTONE.get(), (Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), (Block)YTechBlocks.PRIMITIVE_SMELTER.get(), (Block)YTechBlocks.REINFORCED_BRICKS.get(), (Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), (Block)YTechBlocks.TERRACOTTA_BRICKS.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get(), (Block)YTechBlocks.WELL_PULLEY.get()}).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.AQUEDUCTS, EnumSet.noneOf(MaterialType.class))).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS)).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD))).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS)).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS)).m_255179_((Object[])YTechBlockTagsProvider.filteredMaterials(YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS));
        this.m_206424_(BlockTags.f_144283_).m_255179_((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.GRAVEL_DEPOSITS)).m_255179_((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.SAND_DEPOSITS));
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.DRYING_RACKS)).m_255179_((Object[])YTechBlockTagsProvider.sortedMaterials(YTechBlocks.TANNING_RACKS)).m_255245_((Object)((Block)YTechBlocks.POTTERS_WHEEL.get())).m_255245_((Object)((Block)YTechBlocks.STRAINER.get())).m_255245_((Object)((Block)YTechBlocks.TOOL_RACK.get())).m_255245_((Object)((Block)YTechBlocks.TREE_STUMP.get())).m_255245_((Object)((Block)YTechBlocks.WOODEN_BOX.get()));
        this.m_206424_(BlockTags.f_144286_).m_255179_((Object[])new Block[]{(Block)YTechBlocks.AQUEDUCT_FERTILIZER.get(), (Block)YTechBlocks.AQUEDUCT_HYDRATOR.get(), (Block)YTechBlocks.AQUEDUCT_VALVE.get(), (Block)YTechBlocks.BRICK_CHIMNEY.get(), (Block)YTechBlocks.BRONZE_ANVIL.get(), (Block)YTechBlocks.MILLSTONE.get(), (Block)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), (Block)YTechBlocks.PRIMITIVE_SMELTER.get(), (Block)YTechBlocks.REINFORCED_BRICKS.get(), (Block)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), (Block)YTechBlocks.TERRACOTTA_BRICKS.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_SLAB.get(), (Block)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get()});
    }

    private void materialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            this.m_206424_(materialTag.of(material)).m_255245_((Object)((Block)materialItem.of(material).get()));
            this.m_206424_(materialTag.tag).m_206428_(materialTag.of(material));
        });
    }

    private void materialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                this.m_206424_(materialTag.of(material)).m_255245_((Object)((Block)materialItem.of(material).get()));
                this.m_206424_(materialTag.tag).m_206428_(materialTag.of(material));
            }
        });
    }

    private void tieredMaterialTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                this.m_206424_(materialTag.of(material)).m_255245_((Object)((Block)materialItem.of(material).get()));
                this.m_206424_(materialTag.tag).m_206428_(materialTag.of(material));
                if (material.getTier().getTag() != null) {
                    this.m_206424_(BlockTags.f_144286_).m_255245_((Object)((Block)((RegistryObject)entry.getValue()).get()));
                }
            }
        });
    }

    private void materialOreTag(YTechBlocks.MaterialBlock materialItem, YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> excludeMaterials) {
        materialItem.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).forEach(entry -> {
            MaterialType material = (MaterialType)entry.getKey();
            if (!excludeMaterials.contains(material)) {
                RegistryObject<Block> block = materialItem.of(material);
                this.m_206424_(materialTag.of(material)).m_255245_((Object)((Block)block.get()));
                this.m_206424_(materialTag.tag).m_255245_((Object)((Block)block.get()));
                this.m_206424_(BlockTags.f_144286_).m_255245_((Object)((Block)block.get()));
                switch (material) {
                    case IRON: {
                        this.m_206424_(BlockTags.f_144258_).m_255245_((Object)((Block)block.get()));
                        break;
                    }
                    case COPPER: {
                        this.m_206424_(BlockTags.f_144264_).m_255245_((Object)((Block)block.get()));
                        break;
                    }
                    case GOLD: {
                        this.m_206424_(BlockTags.f_13043_).m_255245_((Object)((Block)block.get()));
                    }
                }
            }
        });
    }

    private static Block[] filteredMaterials(YTechBlocks.MaterialBlock block, EnumSet<MaterialType> exclude) {
        return (Block[])block.entries().stream().filter(entry -> !exclude.contains(entry.getKey())).sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).map(Map.Entry::getValue).map(RegistryObject::get).toArray(Block[]::new);
    }

    private static Block[] sortedMaterials(YTechBlocks.MaterialBlock block) {
        return (Block[])block.entries().stream().sorted(Comparator.comparing(t -> ((MaterialType)t.getKey()).key)).map(Map.Entry::getValue).map(RegistryObject::get).toArray(Block[]::new);
    }
}

