/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic.client;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.generic.client.ClientLevelData;
import com.yanny.ytech.network.generic.client.ClientNetwork;
import com.yanny.ytech.network.generic.common.CommonNetwork;
import com.yanny.ytech.network.generic.common.INetworkBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ClientPropagator<N extends ClientNetwork, B extends INetworkBlockEntity> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final HashMap<ResourceLocation, ClientLevelData<N, B>> levelMap = new HashMap();
    @NotNull
    private final String networkName;

    public ClientPropagator(@NotNull String networkName) {
        this.networkName = networkName;
    }

    public void onLevelLoad(@NotNull ClientLevel level) {
        ResourceLocation id = NetworkUtils.getLevelId((Level)level);
        LOGGER.debug("[{}] Preparing propagators for {}", (Object)this.networkName, (Object)id);
        this.levelMap.put(id, new ClientLevelData());
        LOGGER.debug("[{}] Prepared propagators for {}", (Object)this.networkName, (Object)id);
    }

    public void onLevelUnload(@NotNull ClientLevel level) {
        ResourceLocation id = NetworkUtils.getLevelId((Level)level);
        LOGGER.debug("[{}] Removing propagator for {}", (Object)this.networkName, (Object)id);
        this.levelMap.remove(id);
        LOGGER.debug("[{}] Removed propagator for {}", (Object)this.networkName, (Object)id);
    }

    public void syncLevel(@NotNull Map<Integer, N> networkMap) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.levelMap.clear();
            this.levelMap.put(NetworkUtils.getLevelId((Level)Minecraft.m_91087_().f_91073_), new ClientLevelData(networkMap));
            LOGGER.debug("[{}] Synced ClientLevel ({} networks)", (Object)this.networkName, (Object)networkMap.size());
        } else {
            LOGGER.warn("[{}] Invalid ClientLevel reference!", (Object)this.networkName);
        }
    }

    public void addOrUpdateNetwork(@NotNull N network) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevelData<N, B> level = this.levelMap.get(NetworkUtils.getLevelId((Level)Minecraft.m_91087_().f_91073_));
            if (level != null) {
                level.onNetworkAddedOrUpdated(network);
                LOGGER.debug("[{}] Added or updated network {} ({})", new Object[]{this.networkName, ((CommonNetwork)network).getNetworkId(), network});
            } else {
                LOGGER.warn("[{}] No level stored for {}", (Object)this.networkName, (Object)Minecraft.m_91087_().f_91073_);
            }
        } else {
            LOGGER.warn("[{}] Invalid ClientLevel reference!", (Object)this.networkName);
        }
    }

    public void deletedNetwork(int networkId) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevelData<N, B> level = this.levelMap.get(NetworkUtils.getLevelId((Level)Minecraft.m_91087_().f_91073_));
            if (level != null) {
                level.onNetworkRemoved(networkId);
                LOGGER.debug("[{}] Removed network {}", (Object)this.networkName, (Object)networkId);
            } else {
                LOGGER.warn("[{}] No level stored for {}", (Object)this.networkName, (Object)Minecraft.m_91087_().f_91073_);
            }
        } else {
            LOGGER.warn("[{}] Invalid ClientLevel reference!", (Object)this.networkName);
        }
    }

    @Nullable
    public N getNetwork(@NotNull B blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            ClientLevelData<N, B> levelData = this.levelMap.get(NetworkUtils.getLevelId((Level)level2));
            if (levelData != null) {
                return levelData.getNetwork(blockEntity);
            }
            LOGGER.warn("[{}] No network for level {}", (Object)this.networkName, (Object)level2);
            return null;
        }
        LOGGER.warn("[{}] Invalid ClientLevel reference: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        return null;
    }
}

