/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon;

import com.a3ot.eventhorizon.config.GeneralConfig;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventSide;
import com.a3ot.eventhorizon.events.EventsRegistry;
import com.a3ot.eventhorizon.events.server.OnlyNegativeEventsEvent;
import com.a3ot.eventhorizon.events.server.OnlyPositiveEventsEvent;
import com.a3ot.eventhorizon.events.server.UnknownEvent;
import com.a3ot.eventhorizon.events.server.X2EventTimeEvent;
import com.a3ot.eventhorizon.events.server.X2TimerEvent;
import com.a3ot.eventhorizon.events.server.X5TimerEvent;
import com.a3ot.eventhorizon.events.utils.IActiveStateEvent;
import com.a3ot.eventhorizon.gui.ActiveEventScoreBoard;
import com.a3ot.eventhorizon.gui.TimerBossBar;
import com.a3ot.eventhorizon.handlers.ServerHandler;
import com.a3ot.eventhorizon.network.packet.ClientEventPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class ServerTick {
    private static int tickCounter = 0;
    private static int totalTicks = 1200;
    private static boolean isRunning = false;
    private static final Map<AbstractEvent, Integer> ACTIVE_EVENTS = new HashMap<AbstractEvent, Integer>();
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();
    private static final Set<Integer> warningTicks = Set.of(Integer.valueOf(20), Integer.valueOf(40), Integer.valueOf(60), Integer.valueOf(80), Integer.valueOf(100));
    private static boolean wasEnabled = false;

    @SubscribeEvent
    private static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (ServerTick.checkModEnabledStatus(server)) {
            return;
        }
        if (!isRunning) {
            return;
        }
        ServerTick.checkAndTriggerNewEvent(server);
        ServerTick.activeEventsTick(server);
        ServerTick.checkWarningTicks(server);
        TimerBossBar.update(tickCounter, totalTicks);
        ++tickCounter;
    }

    private static boolean checkModEnabledStatus(MinecraftServer server) {
        boolean isEnabled = ServerTick.isEnabled();
        if (isEnabled != wasEnabled) {
            if (isEnabled) {
                TimerBossBar.initialize(server);
                ActiveEventScoreBoard.initialize(server);
                ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(isRunning, server);
            } else {
                TimerBossBar.deinitialize(server);
                ActiveEventScoreBoard.deinitialize(server);
                ServerTick.resetTimerAndEvents(server);
            }
            wasEnabled = isEnabled;
        }
        return !isEnabled;
    }

    private static void resetTimerAndEvents(MinecraftServer server) {
        isRunning = false;
        tickCounter = 0;
        ACTIVE_EVENTS.clear();
        ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(true, server);
    }

    private static void checkWarningTicks(MinecraftServer server) {
        if (!UnknownEvent.isActive() && warningTicks.contains(totalTicks - tickCounter)) {
            server.getPlayerList().getPlayers().forEach(player -> {
                if (ServerHandler.isClientWarningSound(player)) {
                    player.playNotifySound(SoundEvents.LEVER_CLICK, SoundSource.MASTER, 1.0f, 1.0f);
                }
            });
        }
    }

    private static void checkAndTriggerNewEvent(MinecraftServer server) {
        if (tickCounter >= totalTicks) {
            List<AbstractEvent> enabledEvents = ServerTick.getFilteredEvents();
            if (!enabledEvents.isEmpty()) {
                AbstractEvent randomEvent = enabledEvents.get(random.nextInt(enabledEvents.size()));
                ServerTick.addActiveEvent(randomEvent, server);
                ServerTick.broadcastEventStart(randomEvent, server);
            }
            tickCounter = 0;
        }
    }

    private static List<AbstractEvent> getFilteredEvents() {
        if (OnlyPositiveEventsEvent.isActive()) {
            return EventsRegistry.getPositiveEvents();
        }
        if (OnlyNegativeEventsEvent.isActive()) {
            return EventsRegistry.getNegativeEvents();
        }
        return EventsRegistry.getEnabledEvents();
    }

    private static void broadcastEventStart(AbstractEvent event, MinecraftServer server) {
        server.getAllLevels().forEach(level -> {
            if (event.getSide() != EventSide.CLIENT) {
                event.onStart((ServerLevel)level);
            }
            if (event.getSide() != EventSide.SERVER) {
                ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.START, server);
            }
        });
        if (!UnknownEvent.isActive() || event instanceof UnknownEvent) {
            event.sendEventNotification(server, event);
        }
    }

    public static void addActiveEvent(AbstractEvent newEvent, MinecraftServer server) {
        int x2EventMultiplier;
        double multiplier = newEvent.getDurationMultiplier();
        int n = x2EventMultiplier = X2EventTimeEvent.isActive() ? 2 : 1;
        if (multiplier <= 0.0) {
            return;
        }
        int durationTicks = (int)((double)((Integer)GeneralConfig.TIMER_DURATION.get() * 20) * multiplier * (double)x2EventMultiplier);
        Iterator<Map.Entry<AbstractEvent, Integer>> iterator = ACTIVE_EVENTS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AbstractEvent, Integer> entry = iterator.next();
            if (!newEvent.conflictsWith(entry.getKey())) continue;
            iterator.remove();
            AbstractEvent event2 = entry.getKey();
            if (event2.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event2::onEnd);
            }
            if (event2.getSide() == EventSide.SERVER) continue;
            ClientEventPacket.sendClientEventPacket(event2, ClientEventPacket.EventType.END, server);
        }
        ACTIVE_EVENTS.compute(newEvent, (event, currentDuration) -> {
            if (currentDuration == null) {
                return durationTicks;
            }
            return currentDuration + durationTicks;
        });
    }

    public static void addActiveEventWithCustomDuration(AbstractEvent newEvent, int durationSeconds, MinecraftServer server) {
        if (newEvent.getDurationMultiplier() <= 0.0) {
            return;
        }
        int durationTicks = durationSeconds * 20;
        Iterator<Map.Entry<AbstractEvent, Integer>> iterator = ACTIVE_EVENTS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AbstractEvent, Integer> entry = iterator.next();
            if (!newEvent.conflictsWith(entry.getKey())) continue;
            iterator.remove();
            AbstractEvent event2 = entry.getKey();
            if (event2.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event2::onEnd);
            }
            if (event2.getSide() == EventSide.SERVER) continue;
            ClientEventPacket.sendClientEventPacket(event2, ClientEventPacket.EventType.END, server);
        }
        ACTIVE_EVENTS.compute(newEvent, (event, currentDuration) -> {
            if (currentDuration == null) {
                return durationTicks;
            }
            return currentDuration + durationTicks;
        });
    }

    private static void activeEventsTick(MinecraftServer server) {
        int currentTick = tickCounter;
        Iterator<Map.Entry<AbstractEvent, Integer>> iterator = ACTIVE_EVENTS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AbstractEvent, Integer> entry = iterator.next();
            AbstractEvent event = entry.getKey();
            Integer duration = entry.getValue();
            if (duration == null || duration <= 0) {
                iterator.remove();
                if (event.getSide() != EventSide.CLIENT) {
                    server.getAllLevels().forEach(event::onEnd);
                }
                if (event.getSide() == EventSide.SERVER) continue;
                ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.END, server);
                continue;
            }
            if (currentTick % event.getInterval() == 0) {
                if (event.getSide() != EventSide.CLIENT && event.requiresPeriodicTick()) {
                    server.getAllLevels().forEach(event::onTick);
                }
                if (event.getSide() != EventSide.SERVER && event.requiresPeriodicClientTick()) {
                    ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.TICK, server);
                }
            }
            entry.setValue(duration - 1);
        }
        ActiveEventScoreBoard.update(server);
    }

    public static int updateTotalTicks() {
        int newTotalTicks = (Integer)GeneralConfig.TIMER_DURATION.get() * 20;
        for (AbstractEvent event : ACTIVE_EVENTS.keySet()) {
            if (event instanceof X2TimerEvent) {
                newTotalTicks /= 2;
                continue;
            }
            if (!(event instanceof X5TimerEvent)) continue;
            newTotalTicks /= 5;
        }
        totalTicks = newTotalTicks;
        return totalTicks;
    }

    public static void start(MinecraftServer server) {
        isRunning = true;
        TimerBossBar.setBossBarColor(true);
        for (Map.Entry<AbstractEvent, Integer> entry : ACTIVE_EVENTS.entrySet()) {
            AbstractEvent event = entry.getKey();
            if (event.getSide() != EventSide.CLIENT) {
                if (event instanceof IActiveStateEvent) {
                    IActiveStateEvent activeStateEvent = (IActiveStateEvent)((Object)event);
                    activeStateEvent.setActive();
                } else {
                    server.getAllLevels().forEach(event::onStart);
                }
            }
            if (event.getSide() == EventSide.SERVER) continue;
            ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.START, server);
        }
        ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(true, server);
    }

    public static void pause(MinecraftServer server) {
        isRunning = false;
        TimerBossBar.setBossBarColor(false);
        for (Map.Entry<AbstractEvent, Integer> entry : ACTIVE_EVENTS.entrySet()) {
            AbstractEvent event = entry.getKey();
            if (event.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event::onEnd);
            }
            if (event.getSide() == EventSide.SERVER) continue;
            ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.END, server);
        }
        ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
    }

    public static int getTickCounter() {
        return tickCounter;
    }

    public static void setTickCounter(int tickCounter) {
        ServerTick.tickCounter = tickCounter;
    }

    public static boolean isEnabled() {
        return (Boolean)GeneralConfig.ENABLE_MOD.get();
    }

    public static int getTotalTicks() {
        return totalTicks;
    }

    public static boolean isRun() {
        return isRunning;
    }

    public static Map<AbstractEvent, Integer> getActiveEvents() {
        return ACTIVE_EVENTS;
    }
}

