/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.commands;

import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventSide;
import com.a3ot.eventhorizon.events.EventsRegistry;
import com.a3ot.eventhorizon.network.packet.ClientEventPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class EventHorizonCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"event").then(Commands.literal((String)"start").executes(context -> {
            if (ServerTick.isEnabled()) {
                ServerTick.start(((CommandSourceStack)context.getSource()).getServer());
                ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
                level.players().forEach(player -> player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.MASTER, 1.0f, 1.0f));
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.start"), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"eventhorizon.commands.modDisabled"));
            }
            return 1;
        }))).then(Commands.literal((String)"pause").executes(context -> {
            ServerTick.pause(((CommandSourceStack)context.getSource()).getServer());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.pause"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"run").requires(source -> source.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument((String)"event", (ArgumentType)StringArgumentType.string()).suggests(EventHorizonCommands::suggestEvents).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> EventHorizonCommands.executeRunCommandWithDuration((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"event"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"))))).executes(context -> EventHorizonCommands.executeRunCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"event")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(source -> source.hasPermission(3))).executes(context -> EventHorizonCommands.executeClearCommand((CommandSourceStack)context.getSource(), null))).then(Commands.argument((String)"event", (ArgumentType)StringArgumentType.string()).suggests(EventHorizonCommands::activeEvents).executes(context -> EventHorizonCommands.executeClearCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"event")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").requires(source -> source.hasPermission(3))).then(Commands.argument((String)"event", (ArgumentType)StringArgumentType.string()).suggests(EventHorizonCommands::suggestEvents).executes(context -> EventHorizonCommands.executeInfoCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"event"))))));
    }

    private static CompletableFuture<Suggestions> suggestEvents(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        EventsRegistry.getAllEvents().forEach(event -> builder.suggest(event.getConfigName()));
        return CompletableFuture.completedFuture(builder.build());
    }

    private static CompletableFuture<Suggestions> activeEvents(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ServerTick.getActiveEvents().keySet().forEach(event -> builder.suggest(event.getConfigName()));
        return CompletableFuture.completedFuture(builder.build());
    }

    private static int executeRunCommand(CommandSourceStack source, String eventName) {
        return EventHorizonCommands.getEventByName(source, eventName).map(event -> {
            MinecraftServer server = source.getServer();
            ServerTick.addActiveEvent(event, server);
            if (event.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event::onStart);
            }
            if (event.getSide() != EventSide.SERVER) {
                ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.START, server);
            }
            source.sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.run.success", (Object[])new Object[]{Component.translatable((String)event.getName())}), false);
            return 1;
        }).orElse(0);
    }

    private static int executeRunCommandWithDuration(CommandSourceStack source, String eventName, int duration) {
        return EventHorizonCommands.getEventByName(source, eventName).map(event -> {
            MinecraftServer server = source.getServer();
            ServerTick.addActiveEventWithCustomDuration(event, duration, server);
            if (event.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event::onStart);
            }
            if (event.getSide() != EventSide.SERVER) {
                ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.START, server);
            }
            source.sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.run.success", (Object[])new Object[]{Component.translatable((String)event.getName()), duration}), false);
            return 1;
        }).orElse(0);
    }

    private static int executeClearCommand(CommandSourceStack source, @Nullable String eventName) {
        MinecraftServer server = source.getServer();
        if (eventName == null || eventName.isEmpty()) {
            ArrayList<AbstractEvent> activeEvents = new ArrayList<AbstractEvent>(ServerTick.getActiveEvents().keySet());
            ServerTick.getActiveEvents().clear();
            activeEvents.forEach(event -> {
                if (event.getSide() != EventSide.CLIENT) {
                    server.getAllLevels().forEach(event::onEnd);
                }
                if (event.getSide() != EventSide.SERVER) {
                    ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.END, server);
                }
            });
            source.sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.clear.all"), false);
            return ServerTick.getActiveEvents().size();
        }
        return EventHorizonCommands.getEventByName(eventName).map(event -> {
            ServerTick.getActiveEvents().remove(event);
            if (event.getSide() != EventSide.CLIENT) {
                server.getAllLevels().forEach(event::onEnd);
            }
            if (event.getSide() != EventSide.SERVER) {
                ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.END, server);
            }
            source.sendSuccess(() -> Component.translatable((String)"eventhorizon.commands.clear.success", (Object[])new Object[]{Component.translatable((String)event.getName())}), false);
            return 1;
        }).orElseGet(() -> {
            source.sendFailure((Component)Component.translatable((String)"eventhorizon.commands.clear.not_found", (Object[])new Object[]{eventName}));
            return 0;
        });
    }

    private static Optional<AbstractEvent> getEventByName(String eventName) {
        return ServerTick.getActiveEvents().keySet().stream().filter(event -> event.getConfigName().equalsIgnoreCase(eventName)).findFirst();
    }

    private static int executeInfoCommand(CommandSourceStack source, String eventName) {
        return EventHorizonCommands.getEventByName(source, eventName).map(event -> {
            MutableComponent info = Component.empty().append((Component)Component.translatable((String)"eventhorizon.commands.info.name")).append((Component)Component.translatable((String)event.getName())).append("\n").append((Component)Component.translatable((String)"eventhorizon.commands.info.description")).append((Component)Component.translatable((String)event.getDescription())).append("\n").append((Component)Component.translatable((String)"eventhorizon.commands.info.type", (Object[])new Object[]{event.getType().toString()})).append("\n").append((Component)Component.translatable((String)"eventhorizon.commands.info.enabled", (Object[])new Object[]{Component.translatable((String)(event.isEnabled() ? "eventhorizon.commands.generic.enabled" : "eventhorizon.commands.generic.disabled"))})).append("\n").append((Component)Component.translatable((String)"eventhorizon.commands.info.durationMultiplier", (Object[])new Object[]{String.valueOf(event.getDurationMultiplier())}));
            source.sendSuccess(() -> EventHorizonCommands.lambda$executeInfoCommand$25((Component)info), false);
            return 1;
        }).orElse(0);
    }

    private static Optional<AbstractEvent> getEventByName(CommandSourceStack source, String name) {
        AbstractEvent event = EventsRegistry.getDisasterEventByName(name);
        if (event == null) {
            source.sendFailure((Component)Component.translatable((String)"eventhorizon.commands.eventNotFound", (Object[])new Object[]{name}));
        }
        return Optional.ofNullable(event);
    }

    private static /* synthetic */ Component lambda$executeInfoCommand$25(Component info) {
        return info;
    }
}

