/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.config;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventsRegistry;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GeneralConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final Map<String, EventConfig> EDIT_EVENTS;
    public static final ModConfigSpec.BooleanValue ENABLE_MOD;
    public static final ModConfigSpec.IntValue TIMER_DURATION;

    private static void processEvents() {
        BUILDER.push("editEvents");
        for (AbstractEvent event : EventsRegistry.getAllEvents()) {
            String name = event.getConfigName();
            BUILDER.push(name);
            ModConfigSpec.BooleanValue enabled = BUILDER.define("enabled", event.getDefaultEnabled());
            ModConfigSpec.DoubleValue duration = null;
            if (event.getDefaultDurationMultiplier() > 0.0) {
                duration = BUILDER.defineInRange("durationMultiplier", event.getDefaultDurationMultiplier(), 0.1, 10.0);
            }
            EDIT_EVENTS.put(name, new EventConfig(enabled, duration));
            BUILDER.pop();
        }
        BUILDER.pop();
    }

    static {
        EDIT_EVENTS = new HashMap<String, EventConfig>();
        ENABLE_MOD = BUILDER.define("enableMod", true);
        TIMER_DURATION = BUILDER.defineInRange("timerDuration", 60, 5, Integer.MAX_VALUE);
        GeneralConfig.processEvents();
        SPEC = BUILDER.build();
    }

    public record EventConfig(ModConfigSpec.BooleanValue enabled, ModConfigSpec.DoubleValue duration) {
    }
}

