/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DeathStorage {
    private static final Map<UUID, DeathData> deathDataMap = new HashMap<UUID, DeathData>();

    public static void recordPlayerDeath(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos deathPos = player.blockPosition();
            ResourceKey dimension = player.level().dimension();
            UUID playerUUID = player.getUUID();
            deathDataMap.put(playerUUID, new DeathData(deathPos, (ResourceKey<Level>)dimension));
        }
    }

    public static DeathData getDeathData(UUID playerUUID) {
        return deathDataMap.get(playerUUID);
    }

    public static void clearDeathData(UUID playerUUID) {
        deathDataMap.remove(playerUUID);
    }

    public static Map<UUID, DeathData> getWorldDataDeathMap() {
        return new HashMap<UUID, DeathData>(deathDataMap);
    }

    public static void setWorldDataDeathMap(Map<UUID, DeathData> data) {
        deathDataMap.clear();
        deathDataMap.putAll(data);
    }

    public static class DeathData {
        public final BlockPos pos;
        public final ResourceKey<Level> dimension;

        public DeathData(BlockPos pos, ResourceKey<Level> dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }
    }
}

