/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.data;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record HiddenItemData(ItemStack itemStack) {
    private final ItemStack itemStack;

    public HiddenItemData(ItemStack itemStack) {
        this.itemStack = itemStack.copy();
    }

    public ItemStack itemStack() {
        return this.itemStack.copy();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiddenItemData that = (HiddenItemData)o;
        return ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)that.itemStack);
    }

    @Override
    public int hashCode() {
        return this.itemStack.isEmpty() ? 0 : this.itemStack.getDescriptionId().hashCode() + this.itemStack.getCount();
    }

    public boolean isEmpty() {
        return this.itemStack.isEmpty();
    }

    public static final class Stream {
        public static final StreamCodec<RegistryFriendlyByteBuf, HiddenItemData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, HiddenItemData>(){

            @NotNull
            public HiddenItemData decode(@NotNull RegistryFriendlyByteBuf buffer) {
                ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                return new HiddenItemData(stack);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buffer, HiddenItemData data) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)(data.isEmpty() ? ItemStack.EMPTY : data.itemStack()));
            }
        };
    }

    public static final class Codec {
        public static final com.mojang.serialization.Codec<HiddenItemData> CODEC = ItemStack.OPTIONAL_CODEC.xmap(HiddenItemData::new, HiddenItemData::itemStack);
    }
}

