/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.data;

import com.a3ot.eventhorizon.EventHorizon;
import com.a3ot.eventhorizon.data.DeathStorage;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventsRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class WorldData
extends SavedData {
    public static final String DATA_NAME = "eventhorizon_world_data";
    private int tickCounter = 0;
    private final Map<AbstractEvent, Integer> activeEvents = new HashMap<AbstractEvent, Integer>();
    private final Map<UUID, DeathStorage.DeathData> deathDataMap = new HashMap<UUID, DeathStorage.DeathData>();
    public static final SavedData.Factory<WorldData> FACTORY = new SavedData.Factory(WorldData::new, WorldData::load);

    @NotNull
    public CompoundTag save(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        tag.putInt("tickCounter", this.tickCounter);
        EventHorizon.LOGGER.info("Saving tickCounter: {}", (Object)this.tickCounter);
        ListTag activeEventsList = new ListTag();
        for (Map.Entry<AbstractEvent, Integer> entry : this.activeEvents.entrySet()) {
            CompoundTag eventTag = new CompoundTag();
            eventTag.putString("event", entry.getKey().getConfigName());
            eventTag.putInt("duration", entry.getValue().intValue());
            activeEventsList.add((Object)eventTag);
            EventHorizon.LOGGER.info("Saving event: {} duration: {}", (Object)entry.getKey().getConfigName(), (Object)entry.getValue());
        }
        tag.put("activeEvents", (Tag)activeEventsList);
        CompoundTag deathDataTag = new CompoundTag();
        for (Map.Entry<UUID, DeathStorage.DeathData> entry : this.deathDataMap.entrySet()) {
            CompoundTag dataTag = new CompoundTag();
            dataTag.putInt("x", entry.getValue().pos.getX());
            dataTag.putInt("y", entry.getValue().pos.getY());
            dataTag.putInt("z", entry.getValue().pos.getZ());
            dataTag.putString("dimension", entry.getValue().dimension.location().toString());
            deathDataTag.put(entry.getKey().toString(), (Tag)dataTag);
            EventHorizon.LOGGER.info("Saving deathPos: {}", (Object)entry.getKey());
        }
        tag.put("deathData", (Tag)deathDataTag);
        return tag;
    }

    public static WorldData load(CompoundTag tag, HolderLookup.Provider registries) {
        WorldData data = new WorldData();
        data.tickCounter = tag.getInt("tickCounter");
        ListTag activeEventsList = tag.getList("activeEvents", 10);
        for (int i = 0; i < activeEventsList.size(); ++i) {
            CompoundTag eventTag = activeEventsList.getCompound(i);
            String eventName = eventTag.getString("event");
            int duration = eventTag.getInt("duration");
            AbstractEvent event = EventsRegistry.getDisasterEventByName(eventName);
            if (event == null) continue;
            data.activeEvents.put(event, duration);
        }
        CompoundTag deathDataTag = tag.getCompound("deathData");
        for (String uuidStr : deathDataTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag dataTag = deathDataTag.getCompound(uuidStr);
                BlockPos pos = new BlockPos(dataTag.getInt("x"), dataTag.getInt("y"), dataTag.getInt("z"));
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dataTag.getString("dimension")));
                data.deathDataMap.put(uuid, new DeathStorage.DeathData(pos, (ResourceKey<Level>)dimension));
            }
            catch (Exception e) {
                EventHorizon.LOGGER.error("Failed to load death data for UUID: {}", (Object)uuidStr, (Object)e);
            }
        }
        return data;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int newTickCounter) {
        this.tickCounter = newTickCounter;
        this.setDirty();
    }

    public Map<AbstractEvent, Integer> getActiveEvents() {
        return this.activeEvents;
    }

    public Map<UUID, DeathStorage.DeathData> getDeathDataMap() {
        return this.deathDataMap;
    }
}

