/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events;

import com.a3ot.eventhorizon.config.GeneralConfig;
import com.a3ot.eventhorizon.events.EventSide;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.handlers.ServerHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface AbstractEvent {
    default public void onStart(ServerLevel level) {
    }

    default public void onTick(ServerLevel level) {
    }

    default public boolean requiresPeriodicTick() {
        return false;
    }

    default public void onEnd(ServerLevel level) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onClientStart(Level level) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onClientTick(Level level) {
    }

    default public boolean requiresPeriodicClientTick() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onClientEnd(Level level) {
    }

    default public void playerRespawnOrJoin(Player player, Level level) {
    }

    default public int getInterval() {
        return 20;
    }

    default public double getDefaultDurationMultiplier() {
        return 2.0;
    }

    default public EventType getType() {
        return EventType.NEGATIVE;
    }

    default public EventSide getSide() {
        return EventSide.SERVER;
    }

    default public boolean conflictsWith(AbstractEvent other) {
        return false;
    }

    default public SoundEvent getSound() {
        return (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
    }

    default public float getVolume() {
        return 1.0f;
    }

    default public float getPitch() {
        return 1.0f;
    }

    default public Component getMessage(AbstractEvent event) {
        return Component.literal((String)"[Event Horizon] ").append((Component)Component.translatable((String)event.getName()).withStyle(event.getColor())).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)event.getDescription()))));
    }

    default public ChatFormatting getColor() {
        return switch (this.getType()) {
            case EventType.NEGATIVE -> ChatFormatting.RED;
            case EventType.POSITIVE -> ChatFormatting.GREEN;
            default -> ChatFormatting.WHITE;
        };
    }

    default public void sendEventNotification(MinecraftServer server, AbstractEvent event) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.sendSystemMessage(event.getMessage(event));
            if (!ServerHandler.isClientEventSound(player)) continue;
            player.playNotifySound(event.getSound(), SoundSource.MASTER, event.getVolume(), event.getPitch());
        }
    }

    default public String getConfigName() {
        String simpleName = this.getClass().getSimpleName();
        String baseName = simpleName.substring(0, simpleName.length() - 5);
        return Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1);
    }

    default public String getName() {
        return "eventhorizon.configuration." + this.getConfigName();
    }

    default public String getDescription() {
        return "eventhorizon.configuration." + this.getConfigName() + ".tooltip";
    }

    default public boolean getDefaultEnabled() {
        return true;
    }

    default public boolean isEnabled() {
        GeneralConfig.EventConfig config = GeneralConfig.EDIT_EVENTS.get(this.getConfigName());
        return config != null && (Boolean)config.enabled().get() != false;
    }

    default public double getDurationMultiplier() {
        GeneralConfig.EventConfig config = GeneralConfig.EDIT_EVENTS.get(this.getConfigName());
        return config != null && config.duration() != null ? (Double)config.duration().get() : 0.0;
    }
}

