/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events;

import com.a3ot.eventhorizon.config.GeneralConfig;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.both.ChibiEvent;
import com.a3ot.eventhorizon.events.both.FlyingFishEvent;
import com.a3ot.eventhorizon.events.both.NoJumpEvent;
import com.a3ot.eventhorizon.events.both.OldWalkingEvent;
import com.a3ot.eventhorizon.events.both.OnlySwimmingPoseEvent;
import com.a3ot.eventhorizon.events.client.CuteFontEvent;
import com.a3ot.eventhorizon.events.client.ForceNarratorEvent;
import com.a3ot.eventhorizon.events.client.FullBrightnessEvent;
import com.a3ot.eventhorizon.events.client.InvertedControlEvent;
import com.a3ot.eventhorizon.events.client.LowFPSEvent;
import com.a3ot.eventhorizon.events.client.LowRenderDistanceEvent;
import com.a3ot.eventhorizon.events.client.MutedEvent;
import com.a3ot.eventhorizon.events.client.NegligentUseEvent;
import com.a3ot.eventhorizon.events.client.NoInventoryEvent;
import com.a3ot.eventhorizon.events.client.NoTransparencyEvent;
import com.a3ot.eventhorizon.events.client.ObfuscateFontEvent;
import com.a3ot.eventhorizon.events.client.PitchMaxEvent;
import com.a3ot.eventhorizon.events.client.PitchMinEvent;
import com.a3ot.eventhorizon.events.client.RandomSoundsEvent;
import com.a3ot.eventhorizon.events.client.ShakyCrosshairEvent;
import com.a3ot.eventhorizon.events.client.SmallGUIEvent;
import com.a3ot.eventhorizon.events.client.SmoothCameraEvent;
import com.a3ot.eventhorizon.events.server.AdventureModeEvent;
import com.a3ot.eventhorizon.events.server.AllItemsAreEdibleEvent;
import com.a3ot.eventhorizon.events.server.AllItemsAreTotemEvent;
import com.a3ot.eventhorizon.events.server.ArcheologyPlusEvent;
import com.a3ot.eventhorizon.events.server.BabyMobsEvent;
import com.a3ot.eventhorizon.events.server.BlindRageEvent;
import com.a3ot.eventhorizon.events.server.BonemealerEvent;
import com.a3ot.eventhorizon.events.server.BotanophobiaEvent;
import com.a3ot.eventhorizon.events.server.ChangeDimensionEvent;
import com.a3ot.eventhorizon.events.server.CreativeFlyEvent;
import com.a3ot.eventhorizon.events.server.CursedVaultEvent;
import com.a3ot.eventhorizon.events.server.DamageBringsToExplosionEvent;
import com.a3ot.eventhorizon.events.server.DeadlyFallsEvent;
import com.a3ot.eventhorizon.events.server.DeleteChunkEvent;
import com.a3ot.eventhorizon.events.server.DementiaEvent;
import com.a3ot.eventhorizon.events.server.DropChallengeEvent;
import com.a3ot.eventhorizon.events.server.EnchantEquipmentEvent;
import com.a3ot.eventhorizon.events.server.EnchantHoneyBottleEvent;
import com.a3ot.eventhorizon.events.server.EnderBloodEvent;
import com.a3ot.eventhorizon.events.server.EquipmentDowngradeEvent;
import com.a3ot.eventhorizon.events.server.EquipmentUpgradeEvent;
import com.a3ot.eventhorizon.events.server.FloorIsMagmaEvent;
import com.a3ot.eventhorizon.events.server.FluidWalkerEvent;
import com.a3ot.eventhorizon.events.server.HappyBirthdayEvent;
import com.a3ot.eventhorizon.events.server.HuntingSeasonEvent;
import com.a3ot.eventhorizon.events.server.InventoryCrossEvent;
import com.a3ot.eventhorizon.events.server.InventoryShuffleEvent;
import com.a3ot.eventhorizon.events.server.KeepInventoryEvent;
import com.a3ot.eventhorizon.events.server.LowGravityEvent;
import com.a3ot.eventhorizon.events.server.MeteorRainEvent;
import com.a3ot.eventhorizon.events.server.NoGravityEvent;
import com.a3ot.eventhorizon.events.server.NyctophobiaEvent;
import com.a3ot.eventhorizon.events.server.OnlyNegativeEventsEvent;
import com.a3ot.eventhorizon.events.server.OnlyPositiveEventsEvent;
import com.a3ot.eventhorizon.events.server.PetCarrierEvent;
import com.a3ot.eventhorizon.events.server.PhotosensitizationEvent;
import com.a3ot.eventhorizon.events.server.RandomBlockDropEvent;
import com.a3ot.eventhorizon.events.server.RandomEntityEvent;
import com.a3ot.eventhorizon.events.server.RandomStructureEvent;
import com.a3ot.eventhorizon.events.server.ReturnToLastDeathEvent;
import com.a3ot.eventhorizon.events.server.SpicedFoodEvent;
import com.a3ot.eventhorizon.events.server.TimeStopEvent;
import com.a3ot.eventhorizon.events.server.UhcEvent;
import com.a3ot.eventhorizon.events.server.UnknownEvent;
import com.a3ot.eventhorizon.events.server.WhereMobsEvent;
import com.a3ot.eventhorizon.events.server.WideMiningEvent;
import com.a3ot.eventhorizon.events.server.WideMobsEvent;
import com.a3ot.eventhorizon.events.server.X2EventTimeEvent;
import com.a3ot.eventhorizon.events.server.X2TimerEvent;
import com.a3ot.eventhorizon.events.server.X5TimerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventsRegistry {
    private static final List<AbstractEvent> ALL_EVENTS = new ArrayList<AbstractEvent>();
    private static volatile List<AbstractEvent> ENABLED_EVENTS = List.of();
    private static final Map<String, AbstractEvent> EVENT_MAP = new HashMap<String, AbstractEvent>();
    private static volatile List<AbstractEvent> POSITIVE_EVENTS = List.of();
    private static volatile List<AbstractEvent> NEGATIVE_EVENTS = List.of();

    public static AbstractEvent getEvent(String name) {
        return EVENT_MAP.get(name);
    }

    public static List<AbstractEvent> getAllEvents() {
        return ALL_EVENTS;
    }

    public static List<AbstractEvent> getEnabledEvents() {
        return ENABLED_EVENTS;
    }

    public static List<AbstractEvent> getPositiveEvents() {
        return POSITIVE_EVENTS;
    }

    public static List<AbstractEvent> getNegativeEvents() {
        return NEGATIVE_EVENTS;
    }

    public static AbstractEvent getDisasterEventByName(String name) {
        return EVENT_MAP.get(name);
    }

    public static void updateEnabledEvents(Map<String, GeneralConfig.EventConfig> editEvents) {
        ArrayList<AbstractEvent> enabledEvents = new ArrayList<AbstractEvent>();
        ArrayList<AbstractEvent> positiveEvents = new ArrayList<AbstractEvent>();
        ArrayList<AbstractEvent> negativeEvents = new ArrayList<AbstractEvent>();
        for (AbstractEvent event : ALL_EVENTS) {
            GeneralConfig.EventConfig config = editEvents.get(event.getConfigName());
            if (config == null || !((Boolean)config.enabled().get()).booleanValue()) continue;
            enabledEvents.add(event);
            if (event.getType() == EventType.NEGATIVE) {
                negativeEvents.add(event);
                continue;
            }
            if (event.getType() != EventType.POSITIVE) continue;
            positiveEvents.add(event);
        }
        ENABLED_EVENTS = List.copyOf(enabledEvents);
        POSITIVE_EVENTS = List.copyOf(positiveEvents);
        NEGATIVE_EVENTS = List.copyOf(negativeEvents);
    }

    static {
        ALL_EVENTS.add(new DropChallengeEvent());
        ALL_EVENTS.add(new HappyBirthdayEvent());
        ALL_EVENTS.add(new AdventureModeEvent());
        ALL_EVENTS.add(new CuteFontEvent());
        ALL_EVENTS.add(new ObfuscateFontEvent());
        ALL_EVENTS.add(new X2TimerEvent());
        ALL_EVENTS.add(new X5TimerEvent());
        ALL_EVENTS.add(new X2EventTimeEvent());
        ALL_EVENTS.add(new InventoryShuffleEvent());
        ALL_EVENTS.add(new InventoryCrossEvent());
        ALL_EVENTS.add(new WideMiningEvent());
        ALL_EVENTS.add(new ChibiEvent());
        ALL_EVENTS.add(new DementiaEvent());
        ALL_EVENTS.add(new TimeStopEvent());
        ALL_EVENTS.add(new RandomStructureEvent());
        ALL_EVENTS.add(new BotanophobiaEvent());
        ALL_EVENTS.add(new FloorIsMagmaEvent());
        ALL_EVENTS.add(new InvertedControlEvent());
        ALL_EVENTS.add(new NoJumpEvent());
        ALL_EVENTS.add(new UhcEvent());
        ALL_EVENTS.add(new EnderBloodEvent());
        ALL_EVENTS.add(new LowGravityEvent());
        ALL_EVENTS.add(new NoGravityEvent());
        ALL_EVENTS.add(new CreativeFlyEvent());
        ALL_EVENTS.add(new KeepInventoryEvent());
        ALL_EVENTS.add(new PhotosensitizationEvent());
        ALL_EVENTS.add(new RandomEntityEvent());
        ALL_EVENTS.add(new BabyMobsEvent());
        ALL_EVENTS.add(new NoInventoryEvent());
        ALL_EVENTS.add(new MutedEvent());
        ALL_EVENTS.add(new PitchMaxEvent());
        ALL_EVENTS.add(new PitchMinEvent());
        ALL_EVENTS.add(new ArcheologyPlusEvent());
        ALL_EVENTS.add(new OnlyNegativeEventsEvent());
        ALL_EVENTS.add(new OnlyPositiveEventsEvent());
        ALL_EVENTS.add(new MeteorRainEvent());
        ALL_EVENTS.add(new DeadlyFallsEvent());
        ALL_EVENTS.add(new ChangeDimensionEvent());
        ALL_EVENTS.add(new UnknownEvent());
        ALL_EVENTS.add(new SmoothCameraEvent());
        ALL_EVENTS.add(new FlyingFishEvent());
        ALL_EVENTS.add(new WhereMobsEvent());
        ALL_EVENTS.add(new FluidWalkerEvent());
        ALL_EVENTS.add(new OldWalkingEvent());
        ALL_EVENTS.add(new WideMobsEvent());
        ALL_EVENTS.add(new AllItemsAreTotemEvent());
        ALL_EVENTS.add(new AllItemsAreEdibleEvent());
        ALL_EVENTS.add(new NyctophobiaEvent());
        ALL_EVENTS.add(new NegligentUseEvent());
        ALL_EVENTS.add(new FullBrightnessEvent());
        ALL_EVENTS.add(new LowFPSEvent());
        ALL_EVENTS.add(new LowRenderDistanceEvent());
        ALL_EVENTS.add(new EnchantEquipmentEvent());
        ALL_EVENTS.add(new EquipmentUpgradeEvent());
        ALL_EVENTS.add(new EquipmentDowngradeEvent());
        ALL_EVENTS.add(new EnchantHoneyBottleEvent());
        ALL_EVENTS.add(new ReturnToLastDeathEvent());
        ALL_EVENTS.add(new CursedVaultEvent());
        ALL_EVENTS.add(new OnlySwimmingPoseEvent());
        ALL_EVENTS.add(new BlindRageEvent());
        ALL_EVENTS.add(new ShakyCrosshairEvent());
        ALL_EVENTS.add(new NoTransparencyEvent());
        ALL_EVENTS.add(new RandomBlockDropEvent());
        ALL_EVENTS.add(new RandomSoundsEvent());
        ALL_EVENTS.add(new BonemealerEvent());
        ALL_EVENTS.add(new PetCarrierEvent());
        ALL_EVENTS.add(new ForceNarratorEvent());
        ALL_EVENTS.add(new DamageBringsToExplosionEvent());
        ALL_EVENTS.add(new DeleteChunkEvent());
        ALL_EVENTS.add(new SpicedFoodEvent());
        ALL_EVENTS.add(new HuntingSeasonEvent());
        ALL_EVENTS.add(new SmallGUIEvent());
        for (AbstractEvent event : ALL_EVENTS) {
            EVENT_MAP.put(event.getConfigName(), event);
        }
    }
}

