/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.client;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventSide;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.handlers.client.ClientVariables;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;

public class CuteFontEvent
implements AbstractEvent {
    private static final String[] PHRASES = new String[]{"UwU", "owo", "OwO", "uwu", ">w<", "^w^", ":3", "^-^", "^_^", "<3", "^u^"};

    @Override
    public void onClientStart(Level level) {
        ClientVariables.cuteFont = true;
    }

    @Override
    public void onClientEnd(Level level) {
        ClientVariables.cuteFont = false;
    }

    @Override
    public EventSide getSide() {
        return EventSide.CLIENT;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 4.0;
    }

    @Override
    public EventType getType() {
        return EventType.NEUTRAL;
    }

    @Override
    public float getPitch() {
        return 1.4f;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.LIGHT_PURPLE;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.CAT_AMBIENT;
    }

    public static String cuteString(String input) {
        if (!ClientVariables.cuteFont) {
            return input;
        }
        return CuteFontEvent.globalTransform(CuteFontEvent.localTransform(input));
    }

    public static String localTransform(String input) {
        if (input == null || input.isEmpty() || input.matches("\\d+")) {
            return input;
        }
        int stringLength = input.length();
        input = input.replaceAll("[rl]", "w").replaceAll("[RL]", "W");
        input = input.replaceAll("ove", "uv").replaceAll("OVE", "UV");
        input = input.replaceAll("!", "!!1!").replaceAll("\\?", "???");
        input = input.replaceAll("\u043d\u0430", "\u043d\u044f").replaceAll("\u041d\u0410", "\u041d\u042f");
        input = input.replaceAll("\u044b", "\u0438").replaceAll("\u042b", "\u0418");
        input = input.replaceAll("\u0440", "\u043b").replaceAll("\u0420", "\u041b");
        input = input.replaceAll("(?U)%(\\p{L})", "%$1".toLowerCase(Locale.ROOT)).replaceAll("(?U)\\$(\\p{L})", "$$1".toLowerCase(Locale.ROOT));
        input = stringLength % 2 == 0 ? input.replaceAll("(?U)(\\p{L})(\\b)", "$1$1$1$1$2") : input.replaceAll("(?U)\\b(\\p{L})(\\p{L}*)\\b", "$1-$1$2");
        return input;
    }

    public static String globalTransform(String input) {
        if (input == null || input.isEmpty() || input.matches("\\d+")) {
            return input;
        }
        String result = input.length() % 3 == 0 ? input.toUpperCase() : input;
        return input.length() > 3 ? result + " " + PHRASES[input.length() % PHRASES.length] : result;
    }
}

