/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.IActiveStateEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BlindRageEvent
implements AbstractEvent,
IActiveStateEvent {
    private static boolean active = false;

    @Override
    public void setActive() {
        active = true;
    }

    @Override
    public void setInactive() {
        active = false;
    }

    public static boolean isActive() {
        return active;
    }

    @Override
    public void onStart(ServerLevel level) {
        this.setActive();
    }

    @Override
    public void onEnd(ServerLevel level) {
        ((GameRules.BooleanValue)level.getServer().getGameRules().getRule(GameRules.RULE_FORGIVE_DEAD_PLAYERS)).set(true, level.getServer());
        ((GameRules.BooleanValue)level.getServer().getGameRules().getRule(GameRules.RULE_UNIVERSAL_ANGER)).set(false, level.getServer());
        this.setInactive();
    }

    public static void playerTick(Player player, Level level) {
        if (!active) {
            return;
        }
        ((GameRules.BooleanValue)level.getServer().getGameRules().getRule(GameRules.RULE_FORGIVE_DEAD_PLAYERS)).set(false, level.getServer());
        ((GameRules.BooleanValue)level.getServer().getGameRules().getRule(GameRules.RULE_UNIVERSAL_ANGER)).set(true, level.getServer());
        if (!Utils.isValidPlayer(player)) {
            return;
        }
        AABB searchBox = BlindRageEvent.getBoundingBoxAroundEntity((Entity)player, 24.0);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, searchBox);
        block4: for (LivingEntity entity : nearbyEntities) {
            Piglin piglin;
            double visibility = player.getVisibilityPercent((Entity)entity);
            double angerDistance = Math.max(24.0 * visibility, 4.0);
            if (entity.distanceToSqr(player.getX(), player.getY(), player.getZ()) > angerDistance * angerDistance) continue;
            if (entity instanceof Piglin && ((piglin = (Piglin)entity).getTarget() == null || !piglin.getTarget().isAlive())) {
                if (!player.hasLineOfSight((Entity)piglin) && !(player.distanceTo((Entity)piglin) <= 4.0f)) continue;
                PiglinAi.wasHurtBy((Piglin)piglin, (LivingEntity)player);
            }
            if (!(entity instanceof NeutralMob)) continue;
            NeutralMob neutralMob = (NeutralMob)entity;
            Objects.requireNonNull(entity);
            int n = 0;
            block5: while (true) {
                LivingEntity livingEntity;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TamableAnimal.class, IronGolem.class}, (Object)livingEntity, n)) {
                    case 0: {
                        TamableAnimal tamable = (TamableAnimal)livingEntity;
                        if (tamable.isTame()) continue block4;
                        n = 1;
                        continue block5;
                    }
                    case 1: {
                        IronGolem golem = (IronGolem)livingEntity;
                        if (golem.isPlayerCreated()) continue block4;
                        n = 2;
                        continue block5;
                    }
                }
                break;
            }
            if (neutralMob.getTarget() != null && neutralMob.getTarget().isAlive() || !player.hasLineOfSight((Entity)entity) && !(player.distanceTo((Entity)entity) <= 4.0f)) continue;
            neutralMob.setTarget((LivingEntity)player);
        }
        List endermen = level.getEntitiesOfClass(EnderMan.class, searchBox);
        for (EnderMan enderman : endermen) {
            if (!(level.getRandom().nextDouble() <= 0.002) || !enderman.teleportTowards((Entity)player) || !player.hasLineOfSight((Entity)enderman)) continue;
            enderman.setTarget((LivingEntity)player);
        }
    }

    public static AABB getBoundingBoxAroundEntity(Entity entity, double radius) {
        return new AABB(entity.getX() - radius, entity.getY() - radius, entity.getZ() - radius, entity.getX() + radius, entity.getY() + radius, entity.getZ() + radius);
    }
}

