/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.ModDamageTypes;
import com.a3ot.eventhorizon.data.ModTags;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.IActiveStateEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BotanophobiaEvent
implements AbstractEvent,
IActiveStateEvent {
    private static boolean active = false;

    @Override
    public void setActive() {
        active = true;
    }

    @Override
    public void setInactive() {
        active = false;
    }

    public static boolean isActive() {
        return active;
    }

    @Override
    public void onStart(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> BotanophobiaEvent.setPlatform((Player)player, level));
        this.setActive();
    }

    @Override
    public void onEnd(ServerLevel level) {
        this.setInactive();
    }

    public static void playerTick(Player player, Level level) {
        if (!active) {
            return;
        }
        if (!Utils.isValidPlayer(player)) {
            return;
        }
        BlockPos entityPos = player.blockPosition();
        ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>(2);
        checkPositions.add(entityPos);
        if (player.onGround()) {
            checkPositions.add(entityPos.below());
        }
        for (BlockPos pos : checkPositions) {
            if (!Utils.isBlockPosHasTag(level, pos, ModTags.Blocks.BOTANOPHOBIA)) continue;
            DamageSource botanophobiaDamage = level.damageSources().source(ModDamageTypes.BOTANOPHOBIA);
            player.hurt(botanophobiaDamage, 2.0f);
            break;
        }
    }

    @Override
    public void playerRespawnOrJoin(Player player, Level level) {
        BotanophobiaEvent.setPlatform(player, (ServerLevel)level);
    }

    public static void setPlatform(Player player, ServerLevel level) {
        BlockPos corner2Check;
        BlockPos playerPos = player.blockPosition();
        int x = playerPos.getX();
        int z = playerPos.getZ();
        int y = playerPos.getY();
        BlockPos corner1Check = new BlockPos(x - 2, y - 2, z - 2);
        boolean hasBotanophobiaBlock = BlockPos.betweenClosedStream((BlockPos)corner1Check, (BlockPos)(corner2Check = new BlockPos(x + 2, y - 1, z + 2))).anyMatch(pos -> Utils.isBlockPosHasTag((Level)level, pos, ModTags.Blocks.BOTANOPHOBIA));
        if (hasBotanophobiaBlock) {
            BlockPos corner1Target = new BlockPos(x - 2, y - 1, z - 2);
            Utils.blockFilling(level, corner1Target, corner2Check, Blocks.TERRACOTTA.defaultBlockState());
        }
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_GREEN;
    }

    @Override
    public float getPitch() {
        return 1.5f;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.THORNS_HIT;
    }
}

