/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.ModTags;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class DeleteChunkEvent
implements AbstractEvent {
    private static final int BLOCKS_PER_TICK = 500;

    @Override
    public void onStart(ServerLevel level) {
        for (ServerPlayer player : level.players()) {
            if (!Utils.isValidPlayer((Player)player)) continue;
            int playerX = (int)player.getX();
            int playerZ = (int)player.getZ();
            int minX = playerX - 8;
            int maxX = playerX + 7;
            int minZ = playerZ - 8;
            int maxZ = playerZ + 7;
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int y = 319; y >= -64; --y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        blocks.add(pos);
                    }
                }
            }
            this.processBlocksAsync((Level)level, blocks, 0);
            MobEffectInstance slow_falling = new MobEffectInstance(MobEffects.SLOW_FALLING, 60, 0, false, false);
            player.addEffect(slow_falling);
        }
    }

    private void processBlocksAsync(Level level, List<BlockPos> blocks, int startIndex) {
        int processed = 0;
        int index = startIndex;
        while (index < blocks.size() && processed < 500) {
            BlockPos pos = blocks.get(index);
            BlockState state = level.getBlockState(pos);
            if (state.is(ModTags.Blocks.IMPORTANT_BLOCKS) || state.isAir()) {
                ++index;
                ++processed;
                continue;
            }
            if (state.is(Tags.Blocks.STORAGE_BLOCKS)) {
                level.destroyBlock(pos, true);
            } else {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            }
            ++index;
            ++processed;
        }
        if (index < blocks.size()) {
            int finalIndex = index;
            Objects.requireNonNull(level.getServer()).submit(() -> this.processBlocksAsync(level, blocks, finalIndex));
        }
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

