/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.HiddenItemData;
import com.a3ot.eventhorizon.data.ModDataComponents;
import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import com.a3ot.eventhorizon.events.subclasses.AbstractRandomSlotInventoryEvent;
import com.a3ot.eventhorizon.registry.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

public class DementiaEvent
extends AbstractRandomSlotInventoryEvent
implements AbstractInventoryEvent.IBasicEvent {
    @Override
    protected int getSlotsToProcessCount() {
        return 1;
    }

    @Override
    protected boolean isSlotEligible(Player player, int slot, ItemStack stack) {
        return !stack.has(ModDataComponents.HIDDEN_ITEM.get()) && slot != player.getInventory().selected;
    }

    @Override
    protected boolean includeArmor() {
        return false;
    }

    @Override
    protected boolean includeOffhand() {
        return false;
    }

    @Override
    public boolean requiresPeriodicTick() {
        return true;
    }

    @Override
    public ItemStack modifyItem(ItemStack stack) {
        ItemStack hidden = new ItemStack((ItemLike)ModItems.HIDDEN_ITEM_PLACEHOLDER.get());
        if (stack.isEmpty()) {
            hidden.set(ModDataComponents.HIDDEN_ITEM.get(), (Object)new HiddenItemData(ItemStack.EMPTY));
        } else {
            hidden.set(ModDataComponents.HIDDEN_ITEM.get(), (Object)new HiddenItemData(stack.copy()));
        }
        return hidden;
    }

    public static ItemStack removePlaceholder(ItemStack stack) {
        if (stack.isEmpty() || !stack.is((Item)ModItems.HIDDEN_ITEM_PLACEHOLDER.get())) {
            return stack;
        }
        HiddenItemData hiddenItem = (HiddenItemData)stack.get(ModDataComponents.HIDDEN_ITEM.get());
        if (hiddenItem == null || hiddenItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return hiddenItem.itemStack();
    }

    public static void playerTick(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack result;
            ItemStack currentStack = player.getItemInHand(hand);
            if (player.level().isClientSide() && currentStack.isEmpty() || !currentStack.is((Item)ModItems.HIDDEN_ITEM_PLACEHOLDER.get()) || ItemStack.matches((ItemStack)currentStack, (ItemStack)(result = DementiaEvent.removePlaceholder(currentStack)))) continue;
            player.setItemInHand(hand, result);
            player.getInventory().setChanged();
        }
    }

    public static void livingDeath(LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        NonNullList items = player.getInventory().items;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack result;
            ItemStack stack = (ItemStack)items.get(i);
            if (!stack.is((Item)ModItems.HIDDEN_ITEM_PLACEHOLDER.get()) || ItemStack.matches((ItemStack)stack, (ItemStack)(result = DementiaEvent.removePlaceholder(stack)))) continue;
            items.set(i, (Object)result);
        }
        player.getInventory().setChanged();
    }

    public static void itemPickup(ItemEntityPickupEvent event) {
        ItemStack result;
        ItemStack itemStack = event.getItemEntity().getItem();
        if (!ItemStack.matches((ItemStack)itemStack, (ItemStack)(result = DementiaEvent.removePlaceholder(itemStack)))) {
            event.getItemEntity().setItem(result);
        }
    }

    @Override
    public int getInterval() {
        return 60;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 3.0;
    }
}

