/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantEquipmentEvent
extends AbstractInventoryEvent
implements AbstractInventoryEvent.ILevelAwareEvent {
    @Override
    public ItemStack modifyItem(ItemStack stack, ServerLevel level) {
        Registry enchantmentRegistry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        List<Holder> enchantments = enchantmentRegistry.holders().map(holder -> holder).toList();
        if (stack.isEmpty() || !EnchantmentHelper.canStoreEnchantments((ItemStack)stack)) {
            return stack;
        }
        List<Holder> applicableEnchantments = enchantments.stream().filter(holder -> ((Enchantment)holder.value()).canEnchant(stack)).filter(holder -> !holder.is(EnchantmentTags.CURSE)).toList();
        if (applicableEnchantments.isEmpty()) {
            return stack;
        }
        Holder selected = applicableEnchantments.get(level.random.nextInt(applicableEnchantments.size()));
        Enchantment enchantment = (Enchantment)selected.value();
        ItemEnchantments existing = stack.getTagEnchantments();
        if (existing.isEmpty()) {
            stack.enchant(selected, enchantment.getMaxLevel());
        } else {
            boolean compatible = existing.keySet().stream().allMatch(holder -> Enchantment.areCompatible((Holder)holder, (Holder)selected));
            if (compatible) {
                stack.enchant(selected, enchantment.getMaxLevel());
            }
        }
        return stack;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_PURPLE;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.ENCHANTMENT_TABLE_USE;
    }

    @Override
    public EventType getType() {
        return EventType.POSITIVE;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

