/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import com.a3ot.eventhorizon.events.subclasses.AbstractRandomSlotInventoryEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HappyBirthdayEvent
extends AbstractRandomSlotInventoryEvent
implements AbstractInventoryEvent.IBasicEvent {
    private static ServerPlayer birthdayBoy;
    private NonNullList<ItemStack> chestItems;

    @Override
    protected int getSlotsToProcessCount() {
        return 3;
    }

    @Override
    public void onStart(ServerLevel level) {
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        List<ServerPlayer> players = level.getServer().getPlayerList().getPlayers().stream().filter(Utils::isValidPlayer).toList();
        if (players.isEmpty()) {
            return;
        }
        birthdayBoy = players.get(level.random.nextInt(players.size()));
        BlockPos pos = birthdayBoy.blockPosition();
        int x = pos.getX();
        int z = pos.getZ();
        int y = pos.getY();
        ServerLevel birthdayLevel = (ServerLevel)birthdayBoy.level();
        Utils.airFilling(birthdayLevel, new BlockPos(x, y, z), new BlockPos(x + 1, y + 1, z + 1));
        birthdayBoy.teleportTo(birthdayLevel, (double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 25.0f);
        this.spawnFireworks(birthdayLevel, birthdayBoy);
        birthdayLevel.setBlock(pos.above().south(2), (BlockState)Blocks.CANDLE_CAKE.defaultBlockState().setValue((Property)CandleCakeBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        birthdayLevel.setBlock(pos.south(2), Blocks.CHEST.defaultBlockState(), 3);
        birthdayLevel.getServer().submit(() -> {
            BlockEntity blockEntity = birthdayLevel.getBlockEntity(pos.south(2));
            if (!(blockEntity instanceof ChestBlockEntity)) {
                return;
            }
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            ResourceKey endCityLoot = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            chest.setLootTable(endCityLoot, birthdayLevel.random.nextLong());
            level.players().stream().filter(player -> player != birthdayBoy && Utils.isValidPlayer((Player)player)).forEach(player -> {
                this.chestItems = chest.getItems();
                this.processRandomSlots(level, (Player)player);
                player.getInventory().setChanged();
                chest.setChanged();
            });
            NonNullList chestItems = chest.getItems();
            Collections.shuffle(chestItems);
            chest.setItems(chestItems);
            chest.setChanged();
        });
    }

    @Override
    public ItemStack modifyItem(ItemStack stack) {
        boolean added = false;
        for (int i = 0; i < this.chestItems.size(); ++i) {
            if (!((ItemStack)this.chestItems.get(i)).isEmpty()) continue;
            this.chestItems.set(i, (Object)stack.copy());
            added = true;
            break;
        }
        if (!added) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public EventType getType() {
        return EventType.POSITIVE;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.LIGHT_PURPLE;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }

    @Override
    public Component getMessage(AbstractEvent event) {
        if (birthdayBoy != null) {
            return Component.literal((String)"[Event Horizon] ").append((Component)Component.translatable((String)event.getName()).append((Component)Component.translatable((String)"eventhorizon.configuration.happyBirthday.playerNickName", (Object[])new Object[]{birthdayBoy.getName()})).withStyle(event.getColor())).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)event.getDescription()))));
        }
        return super.getMessage(event);
    }

    private void spawnFireworks(ServerLevel level, ServerPlayer player) {
        int[][] colors = new int[][]{{255, 0, 0}, {0, 255, 0}, {0, 0, 255}};
        Vec3 playerPos = player.position();
        for (int i = 0; i < 3; ++i) {
            double angle = Math.toRadians(i * 120);
            double radius = 3.0;
            double x = playerPos.x() + radius * Math.cos(angle);
            double z = playerPos.z() + radius * Math.sin(angle);
            double y = playerPos.y();
            ItemStack fireworkStack = this.createFireworkWithColor(colors[i][0], colors[i][1], colors[i][2]);
            FireworkRocketEntity firework = new FireworkRocketEntity((Level)level, fireworkStack, x, y, z, false);
            level.addFreshEntity((Entity)firework);
        }
    }

    private ItemStack createFireworkWithColor(int red, int green, int blue) {
        IntArrayList colorList = new IntArrayList();
        int combinedColor = red << 16 | green << 8 | blue;
        colorList.add(combinedColor);
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.STAR, (IntList)colorList, IntList.of(), true, true);
        Fireworks fireworks = new Fireworks(1, List.of(explosion));
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1);
        fireworkStack.set(DataComponents.FIREWORKS, (Object)fireworks);
        return fireworkStack;
    }
}

