/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryCrossEvent
implements AbstractEvent {
    private static final int ARMOR_SLOTS_START = 36;
    private static final int ARMOR_SLOTS_END = 39;
    private static final int OFFHAND_SLOT = 40;
    private static final int MAIN_INVENTORY_END = 35;

    @Override
    public void onStart(ServerLevel level) {
        List<ServerPlayer> players = level.players().stream().filter(Utils::isValidPlayer).toList();
        if (players.isEmpty()) {
            return;
        }
        if (players.size() == 1) {
            level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
                int i;
                Inventory inventory = player.getInventory();
                ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
                allItems.addAll((Collection<ItemStack>)inventory.items);
                allItems.addAll((Collection<ItemStack>)inventory.armor);
                allItems.add((ItemStack)inventory.offhand.getFirst());
                Collections.shuffle(allItems);
                int slotIndex = 0;
                for (i = 0; i < inventory.items.size(); ++i) {
                    inventory.items.set(i, (Object)((ItemStack)allItems.get(slotIndex)));
                    ++slotIndex;
                }
                for (i = 0; i < inventory.armor.size(); ++i) {
                    inventory.armor.set(i, (Object)((ItemStack)allItems.get(slotIndex)));
                    ++slotIndex;
                }
                inventory.offhand.set(0, (Object)((ItemStack)allItems.get(slotIndex)));
                inventory.setChanged();
            });
        } else {
            Inventory inv;
            ArrayList<NonNullList> inventoryCopies = new ArrayList<NonNullList>();
            for (ServerPlayer player2 : players) {
                int i;
                NonNullList copy = NonNullList.create();
                inv = player2.getInventory();
                for (i = 0; i <= 35; ++i) {
                    copy.add((Object)inv.getItem(i).copy());
                }
                for (i = 36; i <= 39; ++i) {
                    copy.add((Object)inv.getItem(i).copy());
                }
                copy.add((Object)inv.getItem(40).copy());
                inventoryCopies.add(copy);
            }
            for (int i = 0; i < players.size(); ++i) {
                int j;
                ServerPlayer player2;
                player2 = players.get(i);
                NonNullList targetInventory = (NonNullList)inventoryCopies.get((i + 1) % players.size());
                inv = player2.getInventory();
                int slotIndex = 0;
                for (j = 0; j <= 35; ++j) {
                    inv.setItem(j, ((ItemStack)targetInventory.get(slotIndex)).copy());
                    ++slotIndex;
                }
                for (j = 36; j <= 39; ++j) {
                    inv.setItem(j, ((ItemStack)targetInventory.get(slotIndex)).copy());
                    ++slotIndex;
                }
                inv.setItem(40, ((ItemStack)targetInventory.get(slotIndex)).copy());
                inv.setChanged();
            }
        }
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_AQUA;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.ILLUSIONER_MIRROR_MOVE;
    }
}

