/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class MeteorRainEvent
implements AbstractEvent {
    private static final Block[] METEOR_MODELS = new Block[]{Blocks.BASALT, Blocks.TUFF, Blocks.ANDESITE, Blocks.BLACKSTONE, Blocks.DEEPSLATE};

    @Override
    public void onTick(ServerLevel level) {
        RandomSource random = level.random;
        for (int i = 0; i < 7; ++i) {
            level.players().stream().filter(Utils::isValidPlayer).forEach(serverPlayerEntity -> {
                double speed = random.nextInt(4) + 1;
                double angle = Math.toRadians(45.0);
                double horizontalSpeed = speed * Math.sin(angle);
                double verticalSpeed = -speed * Math.cos(angle);
                double direction = Math.PI;
                double dx = horizontalSpeed * Math.cos(direction);
                double dz = horizontalSpeed * Math.sin(direction);
                LargeFireball meteor = new LargeFireball(serverPlayerEntity.level(), (LivingEntity)serverPlayerEntity, new Vec3(dx, verticalSpeed, dz), 4);
                meteor.setOwner((Entity)meteor);
                meteor.setItem(new ItemStack((ItemLike)METEOR_MODELS[random.nextInt(METEOR_MODELS.length)]));
                meteor.setPos(serverPlayerEntity.getX() + (double)random.nextInt(100), serverPlayerEntity.getY() + 50.0 + (double)(random.nextInt(10) - 5), serverPlayerEntity.getZ() + (double)(random.nextInt(100) - 50));
                serverPlayerEntity.level().addFreshEntity((Entity)meteor);
            });
        }
    }

    @Override
    public boolean requiresPeriodicTick() {
        return true;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 1.0;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.FIRECHARGE_USE;
    }
}

