/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.ModDamageTypes;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.server.PhotosensitizationEvent;
import com.a3ot.eventhorizon.events.utils.IActiveStateEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class NyctophobiaEvent
implements AbstractEvent,
IActiveStateEvent {
    private static boolean active = false;

    @Override
    public void setActive() {
        active = true;
    }

    @Override
    public void setInactive() {
        active = false;
    }

    public static boolean isActive() {
        return active;
    }

    @Override
    public void onStart(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
            BlockPos pos = player.getOnPos();
            if (level.dimension() != Level.NETHER && Utils.lightManager(pos.above(), (Level)level) < 10) {
                Utils.blockFilling(level, pos, pos, Blocks.SHROOMLIGHT);
            }
        });
        this.setActive();
    }

    @Override
    public void onEnd(ServerLevel level) {
        this.setInactive();
    }

    public static void playerTick(Player player, Level level) {
        if (!active) {
            return;
        }
        if (!Utils.isValidPlayer((Player)((ServerPlayer)player))) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        int lightLevel = Utils.lightManager(playerPos, level);
        if (lightLevel < 3) {
            DamageSource botanophobiaDamage = level.damageSources().source(ModDamageTypes.NYCTOPHOBIA);
            player.hurt(botanophobiaDamage, 2.0f);
        }
    }

    @Override
    public void playerRespawnOrJoin(Player player, Level level) {
        if (!Utils.isValidPlayer(player)) {
            return;
        }
        BlockPos pos = player.getOnPos();
        if (level.dimension() != Level.NETHER && Utils.lightManager(pos.above(), level) < 10) {
            Utils.blockFilling((ServerLevel)level, pos, pos, Blocks.SHROOMLIGHT);
        }
    }

    @Override
    public boolean conflictsWith(AbstractEvent other) {
        return other instanceof PhotosensitizationEvent;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_GRAY;
    }

    @Override
    public float getPitch() {
        return 0.7f;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.WARDEN_AGITATED;
    }
}

