/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RandomEntityEvent
implements AbstractEvent {
    @Override
    public void onStart(ServerLevel level) {
        RandomSource random = level.random;
        Registry entityTypeRegistry = level.registryAccess().registryOrThrow(Registries.ENTITY_TYPE);
        List<EntityType> summonableEntities = entityTypeRegistry.stream().filter(EntityType::canSummon).filter(type -> type != EntityType.ENDER_DRAGON).toList();
        for (Entity entity : level.getAllEntities()) {
            if (entity == null || entity instanceof Player || entity instanceof EnderDragon) continue;
            Vec3 originalPos = entity.position();
            BlockPos originalBlockPos = entity.blockPosition();
            EntityType newEntityType = summonableEntities.get(random.nextInt(summonableEntities.size()));
            Holder newEntityTypeHolder = entityTypeRegistry.wrapAsHolder((Object)newEntityType);
            Entity newEntity = ((EntityType)newEntityTypeHolder.value()).create((Level)level);
            if (newEntity != null) {
                newEntity.moveTo(originalPos.x, originalPos.y, originalPos.z, entity.getYRot(), entity.getXRot());
                entity.unRide();
                entity.discard();
                if (level.tryAddFreshEntityWithPassengers(newEntity)) {
                    if (!(newEntity instanceof Mob)) continue;
                    Mob newMob = (Mob)newEntity;
                    newMob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(originalBlockPos), MobSpawnType.EVENT, null);
                    continue;
                }
                level.getServer().sendSystemMessage((Component)Component.literal((String)("Failed to spawn entity " + String.valueOf(newEntityType) + " at " + String.valueOf(originalPos))).withStyle(ChatFormatting.RED));
                continue;
            }
            level.getServer().sendSystemMessage((Component)Component.literal((String)("Failed to create entity " + String.valueOf(newEntityType))).withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public EventType getType() {
        return EventType.NEUTRAL;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_AQUA;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

