/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class RandomStructureEvent
implements AbstractEvent {
    private static String nameStructure;
    private static ServerPlayer player;

    @Override
    public void onStart(ServerLevel level) {
        ChunkPos maxChunk;
        List<ServerPlayer> players = level.players().stream().filter(Utils::isValidPlayer).toList();
        if (players.isEmpty()) {
            return;
        }
        player = players.get(level.random.nextInt(players.size()));
        if (player == null) {
            return;
        }
        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        List structures = structureRegistry.stream().toList();
        if (structures.isEmpty()) {
            return;
        }
        Structure randomStructure = (Structure)structures.get(level.random.nextInt(structures.size()));
        nameStructure = Objects.requireNonNull(structureRegistry.getKey((Object)randomStructure)).toString();
        BlockPos pos = player.blockPosition().relative(Direction.NORTH, 5);
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        StructureStart structureStart = randomStructure.generate(level.registryAccess(), chunkGenerator, chunkGenerator.getBiomeSource(), level.getChunkSource().randomState(), level.getStructureManager(), level.getSeed(), new ChunkPos(pos), 0, (LevelHeightAccessor)level, context -> true);
        if (!structureStart.isValid()) {
            return;
        }
        BoundingBox boundingBox = structureStart.getBoundingBox();
        ChunkPos minChunk = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.minX()), SectionPos.blockToSectionCoord((int)boundingBox.minZ()));
        boolean allLoaded = ChunkPos.rangeClosed((ChunkPos)minChunk, (ChunkPos)(maxChunk = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.maxX()), SectionPos.blockToSectionCoord((int)boundingBox.maxZ())))).allMatch(chunkPos -> level.isLoaded(chunkPos.getWorldPosition()));
        if (!allLoaded) {
            return;
        }
        ChunkPos.rangeClosed((ChunkPos)minChunk, (ChunkPos)maxChunk).forEach(chunkPos -> {
            BoundingBox chunkBox = new BoundingBox(chunkPos.getMinBlockX(), level.getMinBuildHeight(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), level.getMaxBuildHeight(), chunkPos.getMaxBlockZ());
            structureStart.placeInChunk((WorldGenLevel)level, level.structureManager(), chunkGenerator, level.getRandom(), chunkBox, chunkPos);
        });
    }

    @Override
    public EventType getType() {
        return EventType.POSITIVE;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_GREEN;
    }

    @Override
    public Component getMessage(AbstractEvent event) {
        if (player != null && nameStructure != null) {
            return Component.literal((String)"[Event Horizon] ").append((Component)Component.translatable((String)event.getName()).append((Component)Component.literal((String)": ")).withStyle(event.getColor())).append((Component)Component.literal((String)nameStructure).withStyle(ChatFormatting.WHITE)).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)event.getDescription()))));
        }
        return AbstractEvent.super.getMessage(event);
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

