/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.DeathStorage;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class ReturnToLastDeathEvent
implements AbstractEvent {
    @Override
    public void onStart(ServerLevel level) {
        ArrayList<ServerPlayer> playersCopy = new ArrayList<ServerPlayer>(level.players().stream().filter(Utils::isValidPlayer).toList());
        playersCopy.forEach(player -> {
            DeathStorage.DeathData deathData = DeathStorage.getDeathData(player.getUUID());
            if (deathData != null) {
                this.teleportPlayer((ServerPlayer)player, deathData);
            } else {
                this.giveTotem((ServerPlayer)player);
            }
        });
    }

    private void teleportPlayer(ServerPlayer player, DeathStorage.DeathData deathData) {
        ServerLevel targetLevel = Objects.requireNonNull(player.getServer()).getLevel(deathData.dimension);
        if (targetLevel != null) {
            BlockPos pos = deathData.pos;
            Vec3 position = Vec3.atBottomCenterOf((Vec3i)pos);
            DimensionTransition.PostDimensionTransition postTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
            DimensionTransition transition = new DimensionTransition(targetLevel, position, player.getDeltaMovement(), player.getYRot(), player.getXRot(), false, postTransition);
            player.changeDimension(transition);
        }
    }

    private void giveTotem(ServerPlayer player) {
        ItemStack totem = new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
        totem.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"eventhorizon.configuration.returnToLastDeath.totem_of_undying").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GRAY)))));
        Utils.giveItem((Player)player, totem);
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.DARK_PURPLE;
    }

    @Override
    public EventType getType() {
        return EventType.NEUTRAL;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

