/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.server;

import com.a3ot.eventhorizon.data.ModDataComponents;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SpicedFoodEvent
extends AbstractInventoryEvent
implements AbstractInventoryEvent.IBasicEvent {
    private static final String SPICE_SUFFIX = "\ud83c\udf56";
    private static boolean hadFood = false;

    @Override
    public void onStart(ServerLevel level) {
        for (ServerPlayer player : level.players()) {
            ItemStack breadStack;
            ItemStack processedStack;
            if (!Utils.isValidPlayer((Player)player)) continue;
            this.processAllSlots(level, (Player)player);
            if (!hadFood && (processedStack = this.modifyItem(breadStack = new ItemStack((ItemLike)Items.BREAD, 16))) != null) {
                Utils.giveItem((Player)player, processedStack);
            }
            hadFood = false;
        }
    }

    @Override
    public ItemStack modifyItem(ItemStack stack) {
        FoodProperties originalFood;
        if (!stack.isEmpty() && stack.has(DataComponents.FOOD) && !stack.has(ModDataComponents.IS_SPICED_FOOD.get()) && (originalFood = (FoodProperties)stack.get(DataComponents.FOOD)) != null) {
            hadFood = true;
            ItemStack newStack = stack.copy();
            int newNutrition = (int)((float)originalFood.nutrition() * 1.5f);
            FoodProperties.Builder foodBuilder = new FoodProperties.Builder().nutrition(newNutrition).saturationModifier(originalFood.saturation() / (float)newNutrition);
            if (originalFood.canAlwaysEat()) {
                foodBuilder.alwaysEdible();
            }
            FoodProperties newFoodProperties = foodBuilder.build();
            newStack.set(DataComponents.FOOD, (Object)newFoodProperties);
            Component originalName = (Component)stack.get(DataComponents.CUSTOM_NAME);
            if (originalName == null) {
                originalName = stack.getItem().getName(stack).copy().withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)));
            }
            MutableComponent suffixComponent = Component.literal((String)" \ud83c\udf56").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GOLD));
            MutableComponent newName = Component.empty().append(originalName).append((Component)suffixComponent);
            newStack.set(DataComponents.CUSTOM_NAME, (Object)newName);
            newStack.set(ModDataComponents.IS_SPICED_FOOD.get(), (Object)true);
            return newStack;
        }
        return stack;
    }

    @Override
    public EventType getType() {
        return EventType.POSITIVE;
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.GOLD;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.LAVA_EXTINGUISH;
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

